% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadELS.R
\name{downloadELS}
\alias{downloadELS}
\title{Download and Unzip ELS Files}
\usage{
downloadELS(root, years = c(2002), cache = FALSE, verbose = TRUE)
}
\arguments{
\item{root}{a character string indicating the directory where the ELS
data should be stored. Files are placed in a
subdirectory named ELS/[year].}

\item{years}{an integer vector of the assessment years to download. Valid year is 2002 only.}

\item{cache}{a logical value set to process and cache the text (.txt) version of files.
This takes a very long time but saves time for future uses of 
the data. Default value is \code{FALSE}.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\description{
Uses an Internet connection to download ELS data. 
             Data come from \href{https://nces.ed.gov/edat/}{nces.ed.gov} zip files. This
             function works for 2002 data.
}
\examples{
\dontrun{
# root argument will vary by operating system conventions
downloadELS(years=2002, root = "~/")

# cache=TRUE will download then process the datafiles
downloadELS(years=2002, root = "~/", cache = TRUE)

# set verbose=FALSE for silent output
# if year not specified, download all years
downloadELS(root="~/", verbose = FALSE)
}
}
\seealso{
\code{\link{readELS}}
}
\author{
Tom Fink
}
