% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineSource.R
\name{lineSource}
\alias{lineSource}
\title{Distribution of emissions by lines}
\source{
OpenstreetMap data avaliable \url{https://www.openstreetmap.org/} and \url{https://download.geofabrik.de/}
}
\usage{
lineSource(
  s,
  grid,
  as_raster = FALSE,
  type = "info",
  gcol = 100,
  grow = 100,
  variable = "length",
  verbose = TRUE
)
}
\arguments{
\item{s}{SpatialLinesDataFrame of SpatialLines object}

\item{grid}{grid object with the grid information or filename}

\item{as_raster}{output format, TRUE for raster, FALSE for matrix}

\item{type}{"info" (default), "wrfinput", "geo", "sp" or "sf" for grid type}

\item{gcol}{grid points for a "sp" or "sf" type}

\item{grow}{grid points for a "sp" or "sf" type}

\item{variable}{variable to use, default is line length}

\item{verbose}{display additional information}
}
\value{
a raster object containing the spatial distribution of emissions
}
\description{
Create a emission distribution from 'sp' or 'sf' spatial lines data.frame or
spatial lines.

There 3 modes available to create the emission grid:
- using gridInfo function output (defoult)
- using the patch to "wrfinput" (output from real.exe) file or "geo" for (output from geog.exe)
- "sf" (and "sp") uses a grid in SpatialPolygons format

The variable is the column of the data.frame with contains the variable to be used as emissions,
by defoult the idstribution taken into acount the lench distribution of lines into each grid cell
and the output is normalized.
}
\examples{
\donttest{
roads <- osmar::get_osm(osmar::complete_file(),
                        source = osmar::osmsource_file(paste(system.file("extdata",
                        package="EmissV"),"/streets.osm.xz",sep="")))
road_lines <- osmar::as_sp(roads,what = "lines")
roads <- sf::st_as_sf(road_lines)

d3    <- gridInfo(paste0(system.file("extdata", package = "EmissV"),"/wrfinput_d03"))

roadLength <- lineSource(roads,d3,as_raster=TRUE)
sp::spplot(roadLength, scales = list(draw=TRUE), ylab="Lat", xlab="Lon",main="Length of roads",
           sp.layout=list("sp.lines", road_lines))
}


}
\seealso{
\code{\link{gridInfo}} and \code{\link{rasterSource}}
}
