% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries_imput.R
\name{timeseries_imput}
\alias{timeseries_imput}
\title{Impute the missing value for the timeseries using the linear interpolation}
\usage{
timeseries_imput(data, date_var, site_var, imput_col)
}
\arguments{
\item{data}{data.frame, contains the refrence id, individual_id and exposure_date}

\item{date_var}{character, varibale name in data, represents the monitoring date.}

\item{site_var}{character, varibale name in data, represents the name of monitoring site.}

\item{imput_col}{numeric,the column position of the target variables need to be imputed}
}
\value{
a data.frame
}
\description{
Complete the time series using the linear interpolation
}
\examples{
library(EnvExpInd)
pollutant_data_com <- timeseries_imput(data= pollutant_data,date_var = "date",
                      site_var = "site.name",imput_col = 3:8)
}
\author{
Bing Zhang, \url{https://github.com/Spatial-R/EnvExpInd}
}
