\name{as.epidat}
\alias{as.epidat}
\title{Continuous Time level information of an Epidemic}
\description{
The function \code{as.epidat} is used to generate objects of class \code{"datagen"}. These objects contain the individual event history of an epidemic along with other individual level information. The output of this function provides information required to fit continuous time individual level models.
}
\usage{
  as.epidat(type, kerneltype, incub.time = NULL, inf.time, rem.time,
  id.individual, location = NULL, network = NULL, network.type = NULL)
}
\arguments{
  \item{type}{type of compartmental framework, with the choice of ``SIR'' for Susceptible-Infectious-Removed and ``SINR'' for Susceptible-Infectious-Notified-Removed.
}
  \item{kerneltype}{type of kernel function with choice of ``distance'' for a distance-based ILM, ``network'' for a contact network-based ILM and ``both'' for a combination of network- and distance-based ILM.
}
  \item{incub.time}{a vector of the incubation times of individuals. It is required when \code{type} = ``SINR''.}
  \item{inf.time}{a vector of the infection times of individuals.}
  \item{rem.time}{a vector of the removal times of individuals.}
  \item{id.individual}{a vector of the id number of individuals.}
  \item{location}{a matrix of the XY coordinates of individuals. It is required when \code{kerneltype} set to either ``distance'' or ``both''.}
  \item{network}{a contact network matrix. It is required when \code{kerneltype} set to either ``network'' or ``both''.}
  \item{network.type}{type of the contact network model, see the argument \code{type} in \code{\link{contactnet}} function.}
}

\details{
The \code{id.individual} is used here to relate individuals to their corresponding row numbers of the \code{location}, and contact \code{network}, matrices. The elements of the \code{incub.time}, \code{inf.time}, and \code{rem.time} vectors must be in sync with those elements of the \code{id.individual} vector. Then, each individual will have an id number and corresponding event times. Any mistake in entering these vectors can seriously affect the use of other functions like \code{epictmcmc} and \code{plot.datagen} which can highly lead to incorrect results and conclusion.
}

\value{
  A class of ``datagen'' which has a list of \code{type}, \code{kerneltype}, a sorted matrix of the epidemic with respect to the infection times in ascending order, the XY coordinates of individuals, and/or the contact network.  
}

\seealso{
  \code{\link{epictmcmc}}, \code{\link{datagen}}, \code{\link{plot.datagen}}.
}

\examples{
# Just for illustation:
# SIR distance-based ILM for a population of 10 individuals:

loc <- cbind(runif(10, 0, 10), runif(10,0,10))
net <- contactnet(type = "random", num.id = 10, location = loc, beta = 0.3)
infection <- c(2.5, 1, 0, 0, 0.5, 0, 2, 1.5, 0, 3)
removal <- c(3.5, 2, 0, 1, 1.5, 0, 3, 2.5, 0, 4)
id <- c(2, 1, 4, 7, 10, 3, 5, 9, 8, 6)

epi <- as.epidat(type = "SIR", kerneltype = "distance", inf.time = infection,
rem.time = removal, id.individual = id, location = loc)
epi

# using the data set generated by using the SINR network-based ILM:

data(NetworkDataSINR)
names(NetworkDataSINR)

netSINR<-as.epidat(type = "SINR", kerneltype = "network", 
incub.time = NetworkDataSINR$epi[,4], inf.time = NetworkDataSINR$epi[,6], 
rem.time = NetworkDataSINR$epi[,2], id.individual = NetworkDataSINR$epi[,1], 
location  = NetworkDataSINR$loc, network = NetworkDataSINR$net, 
network.type = "powerlaw")
names(netSINR)
plot(netSINR, plottype = "history")

netSIR<-as.epidat(type = "SIR", kerneltype = "network", 
inf.time = NetworkDataSINR$epi[,6], rem.time = NetworkDataSINR$epi[,2], 
id.individual = NetworkDataSINR$epi[,1], location  = NetworkDataSINR$loc, 
network = NetworkDataSINR$net, network.type = "powerlaw")
names(netSIR)
plot(netSIR, plottype = "history")
}
