% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init.icm}
\alias{init.icm}
\title{Initial Conditions for Stochastic Individual Contact Models}
\usage{
init.icm(s.num, i.num, r.num, s.num.g2, i.num.g2, r.num.g2,
  status.rand = FALSE, ...)
}
\arguments{
\item{s.num}{Number of initial susceptible. For two-group models, this is
the number of initial group 1 susceptible.}

\item{i.num}{Number of initial infected. For two-group models, this is the
number of initial group 1 infected.}

\item{r.num}{Number of initial recovered. For two-group models, this is the
number of initial group 1 recovered. This parameter is only used for
the \code{SIR} model type.}

\item{s.num.g2}{Number of initial susceptible in group 2. This parameter is
only used for two-group models.}

\item{i.num.g2}{Number of initial infected in group 2. This parameter is only
used for two-group models.}

\item{r.num.g2}{Number of initial recovered in group 2. This parameter is
only used for two-group \code{SIR} models.}

\item{status.rand}{If \code{TRUE}, sets infection based on random binomial
draws from the distribution implied by the number susceptible, infected,
and recovered in each group.}

\item{...}{Additional initial conditions passed to model.}
}
\description{
Sets the initial conditions for stochastic individual contact
             models simulated with \code{icm}.
}
\details{
The initial conditions for a model solved with \code{\link{icm}} should be
input into the \code{init.icm} function. This function handles initial
conditions for both base models and original models using new modules. For
an overview of initial conditions for base ICM class models, consult the
\href{http://statnet.github.io/tut/BasicICMs.html}{Basic ICMs} tutorial.
}
\seealso{
Use \code{\link{param.icm}} to specify model parameters and
         \code{\link{control.icm}} to specify the control settings. Run the
         parameterized model with \code{\link{icm}}.
}
\keyword{parameterization}
