// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_estimate_infections_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_estimate_infections");
    reader.add_event(1, 1, "include", "functions/convolve.stan");
    reader.add_event(1, 0, "start", "functions/convolve.stan");
    reader.add_event(14, 13, "end", "functions/convolve.stan");
    reader.add_event(14, 2, "restart", "model_estimate_infections");
    reader.add_event(14, 2, "include", "functions/discretised_lognormal_pmf.stan");
    reader.add_event(14, 0, "start", "functions/discretised_lognormal_pmf.stan");
    reader.add_event(23, 9, "end", "functions/discretised_lognormal_pmf.stan");
    reader.add_event(23, 3, "restart", "model_estimate_infections");
    reader.add_event(23, 3, "include", "functions/discretised_gamma_pmf.stan");
    reader.add_event(23, 0, "start", "functions/discretised_gamma_pmf.stan");
    reader.add_event(40, 17, "end", "functions/discretised_gamma_pmf.stan");
    reader.add_event(40, 4, "restart", "model_estimate_infections");
    reader.add_event(40, 4, "include", "functions/approximate_gp_functions.stan");
    reader.add_event(40, 0, "start", "functions/approximate_gp_functions.stan");
    reader.add_event(65, 25, "end", "functions/approximate_gp_functions.stan");
    reader.add_event(65, 5, "restart", "model_estimate_infections");
    reader.add_event(354, 292, "end", "model_estimate_infections");
    return reader;
}
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& cases,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& pdf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(cases));
        current_statement_begin__ = 5;
        int max_pdf(0);
        (void) max_pdf;  // dummy to suppress unused var warning
        stan::math::fill(max_pdf, std::numeric_limits<int>::min());
        stan::math::assign(max_pdf,num_elements(pdf));
        current_statement_begin__ = 6;
        validate_non_negative_index("convolved_cases", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> convolved_cases(t);
        stan::math::initialize(convolved_cases, DUMMY_VAR__);
        stan::math::fill(convolved_cases, DUMMY_VAR__);
        stan::math::assign(convolved_cases,rep_vector(1e-5, t));
        current_statement_begin__ = 7;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 8;
            stan::model::assign(convolved_cases, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (stan::model::rvalue(convolved_cases, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "convolved_cases") + dot_product(stan::model::rvalue(cases, stan::model::cons_list(stan::model::index_min_max(std::max(1, ((s - max_pdf) + 1)), s), stan::model::nil_index_list()), "cases"), tail(pdf, std::min(max_pdf, s)))), 
                        "assigning variable convolved_cases");
        }
        current_statement_begin__ = 10;
        return stan::math::promote_scalar<fun_return_scalar_t__>(convolved_cases);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& cases,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& pdf, std::ostream* pstream__) const {
        return convolve(cases, pdf, pstream__);
    }
};
template <typename T1__, typename T2__>
typename boost::math::tools::promote_args<T1__, T2__>::type
discretised_lognormal_pmf(const int& y,
                              const T1__& mu,
                              const T2__& sigma,
                              const int& max_val, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 16;
        local_scalar_t__ adj_y(DUMMY_VAR__);
        (void) adj_y;  // dummy to suppress unused var warning
        stan::math::initialize(adj_y, DUMMY_VAR__);
        stan::math::fill(adj_y, DUMMY_VAR__);
        stan::math::assign(adj_y,(y + 1e-5));
        current_statement_begin__ = 17;
        return stan::math::promote_scalar<fun_return_scalar_t__>(((normal_cdf(((stan::math::log((adj_y + 1)) - mu) / sigma), 0.0, 1.0) - normal_cdf(((stan::math::log(adj_y) - mu) / sigma), 0.0, 1.0)) / normal_cdf(((stan::math::log(max_val) - mu) / sigma), 0.0, 1.0)));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct discretised_lognormal_pmf_functor__ {
    template <typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T1__, T2__>::type
    operator()(const int& y,
                              const T1__& mu,
                              const T2__& sigma,
                              const int& max_val, std::ostream* pstream__) const {
        return discretised_lognormal_pmf(y, mu, sigma, max_val, pstream__);
    }
};
template <typename T1__, typename T2__>
typename boost::math::tools::promote_args<T1__, T2__>::type
discretised_gamma_pmf(const int& y,
                          const T1__& mu,
                          const T2__& sigma,
                          const int& max_val, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 25;
        local_scalar_t__ c_sigma(DUMMY_VAR__);
        (void) c_sigma;  // dummy to suppress unused var warning
        stan::math::initialize(c_sigma, DUMMY_VAR__);
        stan::math::fill(c_sigma, DUMMY_VAR__);
        stan::math::assign(c_sigma,(sigma + 1e-5));
        current_statement_begin__ = 26;
        local_scalar_t__ alpha(DUMMY_VAR__);
        (void) alpha;  // dummy to suppress unused var warning
        stan::math::initialize(alpha, DUMMY_VAR__);
        stan::math::fill(alpha, DUMMY_VAR__);
        stan::math::assign(alpha,pow((mu / c_sigma), 2));
        current_statement_begin__ = 27;
        local_scalar_t__ beta(DUMMY_VAR__);
        (void) beta;  // dummy to suppress unused var warning
        stan::math::initialize(beta, DUMMY_VAR__);
        stan::math::fill(beta, DUMMY_VAR__);
        stan::math::assign(beta,(mu / pow(c_sigma, 2)));
        current_statement_begin__ = 29;
        stan::math::assign(alpha, (logical_lt(alpha, 0) ? stan::math::promote_scalar<local_scalar_t__>(1e-5) : stan::math::promote_scalar<local_scalar_t__>(alpha) ));
        current_statement_begin__ = 30;
        stan::math::assign(beta, (logical_lt(beta, 0) ? stan::math::promote_scalar<local_scalar_t__>(1e-5) : stan::math::promote_scalar<local_scalar_t__>(beta) ));
        current_statement_begin__ = 31;
        stan::math::assign(alpha, (is_inf(alpha) ? stan::math::promote_scalar<local_scalar_t__>(1e8) : stan::math::promote_scalar<local_scalar_t__>(alpha) ));
        current_statement_begin__ = 32;
        stan::math::assign(beta, (is_inf(beta) ? stan::math::promote_scalar<local_scalar_t__>(1e8) : stan::math::promote_scalar<local_scalar_t__>(beta) ));
        current_statement_begin__ = 33;
        return stan::math::promote_scalar<fun_return_scalar_t__>(((gamma_cdf((y + 1), alpha, beta) - gamma_cdf(y, alpha, beta)) / (gamma_cdf(max_val, alpha, beta) - gamma_cdf(1, alpha, beta))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct discretised_gamma_pmf_functor__ {
    template <typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T1__, T2__>::type
    operator()(const int& y,
                          const T1__& mu,
                          const T2__& sigma,
                          const int& max_val, std::ostream* pstream__) const {
        return discretised_gamma_pmf(y, mu, sigma, max_val, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
spd_SE(const T0__& alpha,
           const T1__& rho,
           const T2__& w, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 40;
        local_scalar_t__ S(DUMMY_VAR__);
        (void) S;  // dummy to suppress unused var warning
        stan::math::initialize(S, DUMMY_VAR__);
        stan::math::fill(S, DUMMY_VAR__);
        current_statement_begin__ = 41;
        stan::math::assign(S, (((pow(alpha, 2) * stan::math::sqrt((2 * stan::math::pi()))) * rho) * stan::math::exp(((-(0.5) * pow(rho, 2)) * pow(w, 2)))));
        current_statement_begin__ = 42;
        return stan::math::promote_scalar<fun_return_scalar_t__>(S);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct spd_SE_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& alpha,
           const T1__& rho,
           const T2__& w, std::ostream* pstream__) const {
        return spd_SE(alpha, rho, w, pstream__);
    }
};
template <typename T0__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
phi_SE(const T0__& L,
           const int& m,
           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 48;
        validate_non_negative_index("fi", "rows(x)", rows(x));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> fi(rows(x));
        stan::math::initialize(fi, DUMMY_VAR__);
        stan::math::fill(fi, DUMMY_VAR__);
        current_statement_begin__ = 49;
        stan::math::assign(fi, multiply((1 / stan::math::sqrt(L)), stan::math::sin(multiply(((m * stan::math::pi()) / (2 * L)), add(x, L)))));
        current_statement_begin__ = 50;
        return stan::math::promote_scalar<fun_return_scalar_t__>(fi);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct phi_SE_functor__ {
    template <typename T0__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const T0__& L,
           const int& m,
           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) const {
        return phi_SE(L, m, x, pstream__);
    }
};
template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
lambda(const T0__& L,
           const int& m, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 56;
        local_scalar_t__ lam(DUMMY_VAR__);
        (void) lam;  // dummy to suppress unused var warning
        stan::math::initialize(lam, DUMMY_VAR__);
        stan::math::fill(lam, DUMMY_VAR__);
        current_statement_begin__ = 57;
        stan::math::assign(lam, pow(((m * stan::math::pi()) / (2 * L)), 2));
        current_statement_begin__ = 58;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lam);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct lambda_functor__ {
    template <typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& L,
           const int& m, std::ostream* pstream__) const {
        return lambda(L, m, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_estimate_infections
  : public stan::model::model_base_crtp<model_estimate_infections> {
private:
        int t;
        int rt;
        int horizon;
        std::vector<int> day_of_week;
        std::vector<int> cases;
        vector_d shifted_cases;
        int delays;
        std::vector<double> delay_mean_sd;
        std::vector<double> delay_mean_mean;
        std::vector<double> delay_sd_mean;
        std::vector<double> delay_sd_sd;
        std::vector<int> max_delay;
        double r_mean;
        double r_sd;
        double gt_mean_sd;
        double gt_mean_mean;
        double gt_sd_mean;
        double gt_sd_sd;
        int max_gt;
        int model_type;
        int estimate_r;
        double L;
        int M;
        double lengthscale_mean;
        double lengthscale_sd;
        int est_week_eff;
        vector_d time;
        vector_d inf_time;
        int stationary;
        int break_no;
        std::vector<int> breakpoints;
        int fixed;
        int future_fixed;
        double r_alpha;
        double r_beta;
        int no_rt_time;
        int rt_h;
        int noise_terms;
        matrix_d PHI;
public:
    model_estimate_infections(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_estimate_infections(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_estimate_infections_namespace::model_estimate_infections";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 66;
            context__.validate_dims("data initialization", "t", "int", context__.to_vec());
            t = int(0);
            vals_i__ = context__.vals_i("t");
            pos__ = 0;
            t = vals_i__[pos__++];
            current_statement_begin__ = 67;
            context__.validate_dims("data initialization", "rt", "int", context__.to_vec());
            rt = int(0);
            vals_i__ = context__.vals_i("rt");
            pos__ = 0;
            rt = vals_i__[pos__++];
            current_statement_begin__ = 68;
            context__.validate_dims("data initialization", "horizon", "int", context__.to_vec());
            horizon = int(0);
            vals_i__ = context__.vals_i("horizon");
            pos__ = 0;
            horizon = vals_i__[pos__++];
            current_statement_begin__ = 69;
            validate_non_negative_index("day_of_week", "rt", rt);
            context__.validate_dims("data initialization", "day_of_week", "int", context__.to_vec(rt));
            day_of_week = std::vector<int>(rt, int(0));
            vals_i__ = context__.vals_i("day_of_week");
            pos__ = 0;
            size_t day_of_week_k_0_max__ = rt;
            for (size_t k_0__ = 0; k_0__ < day_of_week_k_0_max__; ++k_0__) {
                day_of_week[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 70;
            validate_non_negative_index("cases", "(rt - horizon)", (rt - horizon));
            context__.validate_dims("data initialization", "cases", "int", context__.to_vec((rt - horizon)));
            cases = std::vector<int>((rt - horizon), int(0));
            vals_i__ = context__.vals_i("cases");
            pos__ = 0;
            size_t cases_k_0_max__ = (rt - horizon);
            for (size_t k_0__ = 0; k_0__ < cases_k_0_max__; ++k_0__) {
                cases[k_0__] = vals_i__[pos__++];
            }
            size_t cases_i_0_max__ = (rt - horizon);
            for (size_t i_0__ = 0; i_0__ < cases_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "cases[i_0__]", cases[i_0__], 0);
            }
            current_statement_begin__ = 71;
            validate_non_negative_index("shifted_cases", "t", t);
            context__.validate_dims("data initialization", "shifted_cases", "vector_d", context__.to_vec(t));
            shifted_cases = Eigen::Matrix<double, Eigen::Dynamic, 1>(t);
            vals_r__ = context__.vals_r("shifted_cases");
            pos__ = 0;
            size_t shifted_cases_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < shifted_cases_j_1_max__; ++j_1__) {
                shifted_cases(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "shifted_cases", shifted_cases, 0);
            current_statement_begin__ = 72;
            context__.validate_dims("data initialization", "delays", "int", context__.to_vec());
            delays = int(0);
            vals_i__ = context__.vals_i("delays");
            pos__ = 0;
            delays = vals_i__[pos__++];
            current_statement_begin__ = 73;
            validate_non_negative_index("delay_mean_sd", "(logical_eq(delays, 0) ? 1 : delays )", (logical_eq(delays, 0) ? 1 : delays ));
            context__.validate_dims("data initialization", "delay_mean_sd", "double", context__.to_vec((logical_eq(delays, 0) ? 1 : delays )));
            delay_mean_sd = std::vector<double>((logical_eq(delays, 0) ? 1 : delays ), double(0));
            vals_r__ = context__.vals_r("delay_mean_sd");
            pos__ = 0;
            size_t delay_mean_sd_k_0_max__ = (logical_eq(delays, 0) ? 1 : delays );
            for (size_t k_0__ = 0; k_0__ < delay_mean_sd_k_0_max__; ++k_0__) {
                delay_mean_sd[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 74;
            validate_non_negative_index("delay_mean_mean", "(logical_eq(delays, 0) ? 1 : delays )", (logical_eq(delays, 0) ? 1 : delays ));
            context__.validate_dims("data initialization", "delay_mean_mean", "double", context__.to_vec((logical_eq(delays, 0) ? 1 : delays )));
            delay_mean_mean = std::vector<double>((logical_eq(delays, 0) ? 1 : delays ), double(0));
            vals_r__ = context__.vals_r("delay_mean_mean");
            pos__ = 0;
            size_t delay_mean_mean_k_0_max__ = (logical_eq(delays, 0) ? 1 : delays );
            for (size_t k_0__ = 0; k_0__ < delay_mean_mean_k_0_max__; ++k_0__) {
                delay_mean_mean[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 75;
            validate_non_negative_index("delay_sd_mean", "(logical_eq(delays, 0) ? 1 : delays )", (logical_eq(delays, 0) ? 1 : delays ));
            context__.validate_dims("data initialization", "delay_sd_mean", "double", context__.to_vec((logical_eq(delays, 0) ? 1 : delays )));
            delay_sd_mean = std::vector<double>((logical_eq(delays, 0) ? 1 : delays ), double(0));
            vals_r__ = context__.vals_r("delay_sd_mean");
            pos__ = 0;
            size_t delay_sd_mean_k_0_max__ = (logical_eq(delays, 0) ? 1 : delays );
            for (size_t k_0__ = 0; k_0__ < delay_sd_mean_k_0_max__; ++k_0__) {
                delay_sd_mean[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 76;
            validate_non_negative_index("delay_sd_sd", "(logical_eq(delays, 0) ? 1 : delays )", (logical_eq(delays, 0) ? 1 : delays ));
            context__.validate_dims("data initialization", "delay_sd_sd", "double", context__.to_vec((logical_eq(delays, 0) ? 1 : delays )));
            delay_sd_sd = std::vector<double>((logical_eq(delays, 0) ? 1 : delays ), double(0));
            vals_r__ = context__.vals_r("delay_sd_sd");
            pos__ = 0;
            size_t delay_sd_sd_k_0_max__ = (logical_eq(delays, 0) ? 1 : delays );
            for (size_t k_0__ = 0; k_0__ < delay_sd_sd_k_0_max__; ++k_0__) {
                delay_sd_sd[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 77;
            validate_non_negative_index("max_delay", "(logical_eq(delays, 0) ? 1 : delays )", (logical_eq(delays, 0) ? 1 : delays ));
            context__.validate_dims("data initialization", "max_delay", "int", context__.to_vec((logical_eq(delays, 0) ? 1 : delays )));
            max_delay = std::vector<int>((logical_eq(delays, 0) ? 1 : delays ), int(0));
            vals_i__ = context__.vals_i("max_delay");
            pos__ = 0;
            size_t max_delay_k_0_max__ = (logical_eq(delays, 0) ? 1 : delays );
            for (size_t k_0__ = 0; k_0__ < max_delay_k_0_max__; ++k_0__) {
                max_delay[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 78;
            context__.validate_dims("data initialization", "r_mean", "double", context__.to_vec());
            r_mean = double(0);
            vals_r__ = context__.vals_r("r_mean");
            pos__ = 0;
            r_mean = vals_r__[pos__++];
            check_greater_or_equal(function__, "r_mean", r_mean, 0);
            current_statement_begin__ = 79;
            context__.validate_dims("data initialization", "r_sd", "double", context__.to_vec());
            r_sd = double(0);
            vals_r__ = context__.vals_r("r_sd");
            pos__ = 0;
            r_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "r_sd", r_sd, 0);
            current_statement_begin__ = 80;
            context__.validate_dims("data initialization", "gt_mean_sd", "double", context__.to_vec());
            gt_mean_sd = double(0);
            vals_r__ = context__.vals_r("gt_mean_sd");
            pos__ = 0;
            gt_mean_sd = vals_r__[pos__++];
            current_statement_begin__ = 81;
            context__.validate_dims("data initialization", "gt_mean_mean", "double", context__.to_vec());
            gt_mean_mean = double(0);
            vals_r__ = context__.vals_r("gt_mean_mean");
            pos__ = 0;
            gt_mean_mean = vals_r__[pos__++];
            current_statement_begin__ = 82;
            context__.validate_dims("data initialization", "gt_sd_mean", "double", context__.to_vec());
            gt_sd_mean = double(0);
            vals_r__ = context__.vals_r("gt_sd_mean");
            pos__ = 0;
            gt_sd_mean = vals_r__[pos__++];
            current_statement_begin__ = 83;
            context__.validate_dims("data initialization", "gt_sd_sd", "double", context__.to_vec());
            gt_sd_sd = double(0);
            vals_r__ = context__.vals_r("gt_sd_sd");
            pos__ = 0;
            gt_sd_sd = vals_r__[pos__++];
            current_statement_begin__ = 84;
            context__.validate_dims("data initialization", "max_gt", "int", context__.to_vec());
            max_gt = int(0);
            vals_i__ = context__.vals_i("max_gt");
            pos__ = 0;
            max_gt = vals_i__[pos__++];
            current_statement_begin__ = 85;
            context__.validate_dims("data initialization", "model_type", "int", context__.to_vec());
            model_type = int(0);
            vals_i__ = context__.vals_i("model_type");
            pos__ = 0;
            model_type = vals_i__[pos__++];
            current_statement_begin__ = 86;
            context__.validate_dims("data initialization", "estimate_r", "int", context__.to_vec());
            estimate_r = int(0);
            vals_i__ = context__.vals_i("estimate_r");
            pos__ = 0;
            estimate_r = vals_i__[pos__++];
            current_statement_begin__ = 87;
            context__.validate_dims("data initialization", "L", "double", context__.to_vec());
            L = double(0);
            vals_r__ = context__.vals_r("L");
            pos__ = 0;
            L = vals_r__[pos__++];
            current_statement_begin__ = 88;
            context__.validate_dims("data initialization", "M", "int", context__.to_vec());
            M = int(0);
            vals_i__ = context__.vals_i("M");
            pos__ = 0;
            M = vals_i__[pos__++];
            check_greater_or_equal(function__, "M", M, 1);
            current_statement_begin__ = 89;
            context__.validate_dims("data initialization", "lengthscale_mean", "double", context__.to_vec());
            lengthscale_mean = double(0);
            vals_r__ = context__.vals_r("lengthscale_mean");
            pos__ = 0;
            lengthscale_mean = vals_r__[pos__++];
            current_statement_begin__ = 90;
            context__.validate_dims("data initialization", "lengthscale_sd", "double", context__.to_vec());
            lengthscale_sd = double(0);
            vals_r__ = context__.vals_r("lengthscale_sd");
            pos__ = 0;
            lengthscale_sd = vals_r__[pos__++];
            current_statement_begin__ = 91;
            context__.validate_dims("data initialization", "est_week_eff", "int", context__.to_vec());
            est_week_eff = int(0);
            vals_i__ = context__.vals_i("est_week_eff");
            pos__ = 0;
            est_week_eff = vals_i__[pos__++];
            current_statement_begin__ = 92;
            validate_non_negative_index("time", "rt", rt);
            context__.validate_dims("data initialization", "time", "vector_d", context__.to_vec(rt));
            time = Eigen::Matrix<double, Eigen::Dynamic, 1>(rt);
            vals_r__ = context__.vals_r("time");
            pos__ = 0;
            size_t time_j_1_max__ = rt;
            for (size_t j_1__ = 0; j_1__ < time_j_1_max__; ++j_1__) {
                time(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 93;
            validate_non_negative_index("inf_time", "t", t);
            context__.validate_dims("data initialization", "inf_time", "vector_d", context__.to_vec(t));
            inf_time = Eigen::Matrix<double, Eigen::Dynamic, 1>(t);
            vals_r__ = context__.vals_r("inf_time");
            pos__ = 0;
            size_t inf_time_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < inf_time_j_1_max__; ++j_1__) {
                inf_time(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 94;
            context__.validate_dims("data initialization", "stationary", "int", context__.to_vec());
            stationary = int(0);
            vals_i__ = context__.vals_i("stationary");
            pos__ = 0;
            stationary = vals_i__[pos__++];
            current_statement_begin__ = 95;
            context__.validate_dims("data initialization", "break_no", "int", context__.to_vec());
            break_no = int(0);
            vals_i__ = context__.vals_i("break_no");
            pos__ = 0;
            break_no = vals_i__[pos__++];
            current_statement_begin__ = 96;
            validate_non_negative_index("breakpoints", "rt", rt);
            context__.validate_dims("data initialization", "breakpoints", "int", context__.to_vec(rt));
            breakpoints = std::vector<int>(rt, int(0));
            vals_i__ = context__.vals_i("breakpoints");
            pos__ = 0;
            size_t breakpoints_k_0_max__ = rt;
            for (size_t k_0__ = 0; k_0__ < breakpoints_k_0_max__; ++k_0__) {
                breakpoints[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 97;
            context__.validate_dims("data initialization", "fixed", "int", context__.to_vec());
            fixed = int(0);
            vals_i__ = context__.vals_i("fixed");
            pos__ = 0;
            fixed = vals_i__[pos__++];
            current_statement_begin__ = 98;
            context__.validate_dims("data initialization", "future_fixed", "int", context__.to_vec());
            future_fixed = int(0);
            vals_i__ = context__.vals_i("future_fixed");
            pos__ = 0;
            future_fixed = vals_i__[pos__++];
            // initialize transformed data variables
            current_statement_begin__ = 102;
            r_alpha = double(0);
            stan::math::fill(r_alpha, DUMMY_VAR__);
            current_statement_begin__ = 103;
            r_beta = double(0);
            stan::math::fill(r_beta, DUMMY_VAR__);
            current_statement_begin__ = 104;
            no_rt_time = int(0);
            stan::math::fill(no_rt_time, std::numeric_limits<int>::min());
            current_statement_begin__ = 105;
            rt_h = int(0);
            stan::math::fill(rt_h, std::numeric_limits<int>::min());
            current_statement_begin__ = 106;
            noise_terms = int(0);
            stan::math::fill(noise_terms, std::numeric_limits<int>::min());
            stan::math::assign(noise_terms,(logical_gt(estimate_r, 0) ? (logical_gt(stationary, 0) ? rt : (rt - 1) ) : t ));
            current_statement_begin__ = 108;
            validate_non_negative_index("PHI", "(logical_gt(future_fixed, 0) ? (noise_terms - horizon) : noise_terms )", (logical_gt(future_fixed, 0) ? (noise_terms - horizon) : noise_terms ));
            validate_non_negative_index("PHI", "M", M);
            PHI = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_gt(future_fixed, 0) ? (noise_terms - horizon) : noise_terms ), M);
            stan::math::fill(PHI, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 111;
            stan::math::assign(noise_terms, (logical_gt(future_fixed, 0) ? (noise_terms - horizon) : noise_terms ));
            current_statement_begin__ = 114;
            stan::math::assign(rt_h, (rt - horizon));
            current_statement_begin__ = 117;
            stan::math::assign(r_alpha, pow((r_mean / r_sd), 2));
            current_statement_begin__ = 118;
            stan::math::assign(r_beta, (r_mean / pow(r_sd, 2)));
            current_statement_begin__ = 121;
            stan::math::assign(no_rt_time, (t - rt));
            current_statement_begin__ = 125;
            for (int m = 1; m <= M; ++m) {
                current_statement_begin__ = 126;
                stan::model::assign(PHI, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                            phi_SE(L, m, (logical_gt(estimate_r, 0) ? stan::math::promote_scalar<double>(stan::model::rvalue(time, stan::model::cons_list(stan::model::index_min_max(1, noise_terms), stan::model::nil_index_list()), "time")) : stan::math::promote_scalar<double>(inf_time) ), pstream__), 
                            "assigning variable PHI");
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 130;
            validate_non_negative_index("day_of_week_eff_raw", "(est_week_eff ? 7 : 1 )", (est_week_eff ? 7 : 1 ));
            num_params_r__ += ((est_week_eff ? 7 : 1 ) - 1);
            current_statement_begin__ = 131;
            validate_non_negative_index("delay_mean", "delays", delays);
            num_params_r__ += (1 * delays);
            current_statement_begin__ = 132;
            validate_non_negative_index("delay_sd", "delays", delays);
            num_params_r__ += (1 * delays);
            current_statement_begin__ = 133;
            validate_non_negative_index("rep_phi", "model_type", model_type);
            num_params_r__ += (1 * model_type);
            current_statement_begin__ = 134;
            validate_non_negative_index("rho", "(fixed ? 0 : 1 )", (fixed ? 0 : 1 ));
            num_params_r__ += (1 * (fixed ? 0 : 1 ));
            current_statement_begin__ = 135;
            validate_non_negative_index("alpha", "(fixed ? 0 : 1 )", (fixed ? 0 : 1 ));
            num_params_r__ += (1 * (fixed ? 0 : 1 ));
            current_statement_begin__ = 136;
            validate_non_negative_index("eta", "(fixed ? 0 : M )", (fixed ? 0 : M ));
            num_params_r__ += (fixed ? 0 : M );
            current_statement_begin__ = 137;
            validate_non_negative_index("initial_R", "estimate_r", estimate_r);
            num_params_r__ += estimate_r;
            current_statement_begin__ = 138;
            validate_non_negative_index("initial_infections", "(logical_gt(estimate_r, 0) ? no_rt_time : 0 )", (logical_gt(estimate_r, 0) ? no_rt_time : 0 ));
            num_params_r__ += (logical_gt(estimate_r, 0) ? no_rt_time : 0 );
            current_statement_begin__ = 140;
            validate_non_negative_index("gt_mean", "estimate_r", estimate_r);
            num_params_r__ += (1 * estimate_r);
            current_statement_begin__ = 141;
            validate_non_negative_index("gt_sd", "estimate_r", estimate_r);
            num_params_r__ += (1 * estimate_r);
            current_statement_begin__ = 142;
            validate_non_negative_index("rt_break_eff", "break_no", break_no);
            num_params_r__ += (1 * break_no);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_estimate_infections() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 130;
        if (!(context__.contains_r("day_of_week_eff_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable day_of_week_eff_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("day_of_week_eff_raw");
        pos__ = 0U;
        validate_non_negative_index("day_of_week_eff_raw", "(est_week_eff ? 7 : 1 )", (est_week_eff ? 7 : 1 ));
        context__.validate_dims("parameter initialization", "day_of_week_eff_raw", "vector_d", context__.to_vec((est_week_eff ? 7 : 1 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> day_of_week_eff_raw((est_week_eff ? 7 : 1 ));
        size_t day_of_week_eff_raw_j_1_max__ = (est_week_eff ? 7 : 1 );
        for (size_t j_1__ = 0; j_1__ < day_of_week_eff_raw_j_1_max__; ++j_1__) {
            day_of_week_eff_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.simplex_unconstrain(day_of_week_eff_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable day_of_week_eff_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 131;
        if (!(context__.contains_r("delay_mean")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delay_mean missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delay_mean");
        pos__ = 0U;
        validate_non_negative_index("delay_mean", "delays", delays);
        context__.validate_dims("parameter initialization", "delay_mean", "double", context__.to_vec(delays));
        std::vector<double> delay_mean(delays, double(0));
        size_t delay_mean_k_0_max__ = delays;
        for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
            delay_mean[k_0__] = vals_r__[pos__++];
        }
        size_t delay_mean_i_0_max__ = delays;
        for (size_t i_0__ = 0; i_0__ < delay_mean_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, delay_mean[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delay_mean: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 132;
        if (!(context__.contains_r("delay_sd")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delay_sd missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delay_sd");
        pos__ = 0U;
        validate_non_negative_index("delay_sd", "delays", delays);
        context__.validate_dims("parameter initialization", "delay_sd", "double", context__.to_vec(delays));
        std::vector<double> delay_sd(delays, double(0));
        size_t delay_sd_k_0_max__ = delays;
        for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
            delay_sd[k_0__] = vals_r__[pos__++];
        }
        size_t delay_sd_i_0_max__ = delays;
        for (size_t i_0__ = 0; i_0__ < delay_sd_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, delay_sd[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delay_sd: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 133;
        if (!(context__.contains_r("rep_phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rep_phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rep_phi");
        pos__ = 0U;
        validate_non_negative_index("rep_phi", "model_type", model_type);
        context__.validate_dims("parameter initialization", "rep_phi", "double", context__.to_vec(model_type));
        std::vector<double> rep_phi(model_type, double(0));
        size_t rep_phi_k_0_max__ = model_type;
        for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
            rep_phi[k_0__] = vals_r__[pos__++];
        }
        size_t rep_phi_i_0_max__ = model_type;
        for (size_t i_0__ = 0; i_0__ < rep_phi_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, rep_phi[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rep_phi: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 134;
        if (!(context__.contains_r("rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "(fixed ? 0 : 1 )", (fixed ? 0 : 1 ));
        context__.validate_dims("parameter initialization", "rho", "double", context__.to_vec((fixed ? 0 : 1 )));
        std::vector<double> rho((fixed ? 0 : 1 ), double(0));
        size_t rho_k_0_max__ = (fixed ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            rho[k_0__] = vals_r__[pos__++];
        }
        size_t rho_i_0_max__ = (fixed ? 0 : 1 );
        for (size_t i_0__ = 0; i_0__ < rho_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, rho[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 135;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "(fixed ? 0 : 1 )", (fixed ? 0 : 1 ));
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec((fixed ? 0 : 1 )));
        std::vector<double> alpha((fixed ? 0 : 1 ), double(0));
        size_t alpha_k_0_max__ = (fixed ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            alpha[k_0__] = vals_r__[pos__++];
        }
        size_t alpha_i_0_max__ = (fixed ? 0 : 1 );
        for (size_t i_0__ = 0; i_0__ < alpha_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, alpha[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 136;
        if (!(context__.contains_r("eta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta");
        pos__ = 0U;
        validate_non_negative_index("eta", "(fixed ? 0 : M )", (fixed ? 0 : M ));
        context__.validate_dims("parameter initialization", "eta", "vector_d", context__.to_vec((fixed ? 0 : M )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta((fixed ? 0 : M ));
        size_t eta_j_1_max__ = (fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            eta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(eta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 137;
        if (!(context__.contains_r("initial_R")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable initial_R missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("initial_R");
        pos__ = 0U;
        validate_non_negative_index("initial_R", "estimate_r", estimate_r);
        context__.validate_dims("parameter initialization", "initial_R", "vector_d", context__.to_vec(estimate_r));
        Eigen::Matrix<double, Eigen::Dynamic, 1> initial_R(estimate_r);
        size_t initial_R_j_1_max__ = estimate_r;
        for (size_t j_1__ = 0; j_1__ < initial_R_j_1_max__; ++j_1__) {
            initial_R(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(initial_R);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable initial_R: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 138;
        if (!(context__.contains_r("initial_infections")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable initial_infections missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("initial_infections");
        pos__ = 0U;
        validate_non_negative_index("initial_infections", "(logical_gt(estimate_r, 0) ? no_rt_time : 0 )", (logical_gt(estimate_r, 0) ? no_rt_time : 0 ));
        context__.validate_dims("parameter initialization", "initial_infections", "vector_d", context__.to_vec((logical_gt(estimate_r, 0) ? no_rt_time : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> initial_infections((logical_gt(estimate_r, 0) ? no_rt_time : 0 ));
        size_t initial_infections_j_1_max__ = (logical_gt(estimate_r, 0) ? no_rt_time : 0 );
        for (size_t j_1__ = 0; j_1__ < initial_infections_j_1_max__; ++j_1__) {
            initial_infections(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(initial_infections);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable initial_infections: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 140;
        if (!(context__.contains_r("gt_mean")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gt_mean missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gt_mean");
        pos__ = 0U;
        validate_non_negative_index("gt_mean", "estimate_r", estimate_r);
        context__.validate_dims("parameter initialization", "gt_mean", "double", context__.to_vec(estimate_r));
        std::vector<double> gt_mean(estimate_r, double(0));
        size_t gt_mean_k_0_max__ = estimate_r;
        for (size_t k_0__ = 0; k_0__ < gt_mean_k_0_max__; ++k_0__) {
            gt_mean[k_0__] = vals_r__[pos__++];
        }
        size_t gt_mean_i_0_max__ = estimate_r;
        for (size_t i_0__ = 0; i_0__ < gt_mean_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, gt_mean[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gt_mean: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 141;
        if (!(context__.contains_r("gt_sd")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gt_sd missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gt_sd");
        pos__ = 0U;
        validate_non_negative_index("gt_sd", "estimate_r", estimate_r);
        context__.validate_dims("parameter initialization", "gt_sd", "double", context__.to_vec(estimate_r));
        std::vector<double> gt_sd(estimate_r, double(0));
        size_t gt_sd_k_0_max__ = estimate_r;
        for (size_t k_0__ = 0; k_0__ < gt_sd_k_0_max__; ++k_0__) {
            gt_sd[k_0__] = vals_r__[pos__++];
        }
        size_t gt_sd_i_0_max__ = estimate_r;
        for (size_t i_0__ = 0; i_0__ < gt_sd_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, gt_sd[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gt_sd: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 142;
        if (!(context__.contains_r("rt_break_eff")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rt_break_eff missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rt_break_eff");
        pos__ = 0U;
        validate_non_negative_index("rt_break_eff", "break_no", break_no);
        context__.validate_dims("parameter initialization", "rt_break_eff", "double", context__.to_vec(break_no));
        std::vector<double> rt_break_eff(break_no, double(0));
        size_t rt_break_eff_k_0_max__ = break_no;
        for (size_t k_0__ = 0; k_0__ < rt_break_eff_k_0_max__; ++k_0__) {
            rt_break_eff[k_0__] = vals_r__[pos__++];
        }
        size_t rt_break_eff_i_0_max__ = break_no;
        for (size_t i_0__ = 0; i_0__ < rt_break_eff_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(rt_break_eff[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rt_break_eff: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 130;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> day_of_week_eff_raw;
            (void) day_of_week_eff_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                day_of_week_eff_raw = in__.simplex_constrain((est_week_eff ? 7 : 1 ), lp__);
            else
                day_of_week_eff_raw = in__.simplex_constrain((est_week_eff ? 7 : 1 ));
            current_statement_begin__ = 131;
            std::vector<local_scalar_t__> delay_mean;
            size_t delay_mean_d_0_max__ = delays;
            delay_mean.reserve(delay_mean_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < delay_mean_d_0_max__; ++d_0__) {
                if (jacobian__)
                    delay_mean.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    delay_mean.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 132;
            std::vector<local_scalar_t__> delay_sd;
            size_t delay_sd_d_0_max__ = delays;
            delay_sd.reserve(delay_sd_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < delay_sd_d_0_max__; ++d_0__) {
                if (jacobian__)
                    delay_sd.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    delay_sd.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 133;
            std::vector<local_scalar_t__> rep_phi;
            size_t rep_phi_d_0_max__ = model_type;
            rep_phi.reserve(rep_phi_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rep_phi_d_0_max__; ++d_0__) {
                if (jacobian__)
                    rep_phi.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    rep_phi.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 134;
            std::vector<local_scalar_t__> rho;
            size_t rho_d_0_max__ = (fixed ? 0 : 1 );
            rho.reserve(rho_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rho_d_0_max__; ++d_0__) {
                if (jacobian__)
                    rho.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    rho.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 135;
            std::vector<local_scalar_t__> alpha;
            size_t alpha_d_0_max__ = (fixed ? 0 : 1 );
            alpha.reserve(alpha_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
                if (jacobian__)
                    alpha.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    alpha.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 136;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta;
            (void) eta;  // dummy to suppress unused var warning
            if (jacobian__)
                eta = in__.vector_constrain((fixed ? 0 : M ), lp__);
            else
                eta = in__.vector_constrain((fixed ? 0 : M ));
            current_statement_begin__ = 137;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> initial_R;
            (void) initial_R;  // dummy to suppress unused var warning
            if (jacobian__)
                initial_R = in__.vector_constrain(estimate_r, lp__);
            else
                initial_R = in__.vector_constrain(estimate_r);
            current_statement_begin__ = 138;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> initial_infections;
            (void) initial_infections;  // dummy to suppress unused var warning
            if (jacobian__)
                initial_infections = in__.vector_constrain((logical_gt(estimate_r, 0) ? no_rt_time : 0 ), lp__);
            else
                initial_infections = in__.vector_constrain((logical_gt(estimate_r, 0) ? no_rt_time : 0 ));
            current_statement_begin__ = 140;
            std::vector<local_scalar_t__> gt_mean;
            size_t gt_mean_d_0_max__ = estimate_r;
            gt_mean.reserve(gt_mean_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < gt_mean_d_0_max__; ++d_0__) {
                if (jacobian__)
                    gt_mean.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    gt_mean.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 141;
            std::vector<local_scalar_t__> gt_sd;
            size_t gt_sd_d_0_max__ = estimate_r;
            gt_sd.reserve(gt_sd_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < gt_sd_d_0_max__; ++d_0__) {
                if (jacobian__)
                    gt_sd.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    gt_sd.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 142;
            std::vector<local_scalar_t__> rt_break_eff;
            size_t rt_break_eff_d_0_max__ = break_no;
            rt_break_eff.reserve(rt_break_eff_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rt_break_eff_d_0_max__; ++d_0__) {
                if (jacobian__)
                    rt_break_eff.push_back(in__.scalar_constrain(lp__));
                else
                    rt_break_eff.push_back(in__.scalar_constrain());
            }
            // transformed parameters
            current_statement_begin__ = 147;
            validate_non_negative_index("noise", "(fixed ? 0 : noise_terms )", (fixed ? 0 : noise_terms ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> noise((fixed ? 0 : noise_terms ));
            stan::math::initialize(noise, DUMMY_VAR__);
            stan::math::fill(noise, DUMMY_VAR__);
            current_statement_begin__ = 148;
            validate_non_negative_index("infections", "t", t);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> infections(t);
            stan::math::initialize(infections, DUMMY_VAR__);
            stan::math::fill(infections, DUMMY_VAR__);
            current_statement_begin__ = 149;
            validate_non_negative_index("reports", "rt", rt);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reports(rt);
            stan::math::initialize(reports, DUMMY_VAR__);
            stan::math::fill(reports, DUMMY_VAR__);
            current_statement_begin__ = 150;
            validate_non_negative_index("day_of_week_eff", "(est_week_eff ? 7 : 0 )", (est_week_eff ? 7 : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> day_of_week_eff((est_week_eff ? 7 : 0 ));
            stan::math::initialize(day_of_week_eff, DUMMY_VAR__);
            stan::math::fill(day_of_week_eff, DUMMY_VAR__);
            current_statement_begin__ = 151;
            validate_non_negative_index("R", "(logical_gt(estimate_r, 0) ? rt : 0 )", (logical_gt(estimate_r, 0) ? rt : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> R((logical_gt(estimate_r, 0) ? rt : 0 ));
            stan::math::initialize(R, DUMMY_VAR__);
            stan::math::fill(R, DUMMY_VAR__);
            // transformed parameters block statements
            {
            current_statement_begin__ = 154;
            validate_non_negative_index("rev_generation_time", "(logical_gt(estimate_r, 0) ? max_gt : 0 )", (logical_gt(estimate_r, 0) ? max_gt : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev_generation_time((logical_gt(estimate_r, 0) ? max_gt : 0 ));
            stan::math::initialize(rev_generation_time, DUMMY_VAR__);
            stan::math::fill(rev_generation_time, DUMMY_VAR__);
            current_statement_begin__ = 155;
            validate_non_negative_index("infectiousness", "(logical_gt(estimate_r, 0) ? rt : 0 )", (logical_gt(estimate_r, 0) ? rt : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> infectiousness((logical_gt(estimate_r, 0) ? rt : 0 ));
            stan::math::initialize(infectiousness, DUMMY_VAR__);
            stan::math::fill(infectiousness, DUMMY_VAR__);
            current_statement_begin__ = 156;
            validate_non_negative_index("diagSPD", "(logical_gt(fixed, 0) ? 0 : M )", (logical_gt(fixed, 0) ? 0 : M ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> diagSPD((logical_gt(fixed, 0) ? 0 : M ));
            stan::math::initialize(diagSPD, DUMMY_VAR__);
            stan::math::fill(diagSPD, DUMMY_VAR__);
            current_statement_begin__ = 157;
            validate_non_negative_index("SPD_eta", "(logical_gt(fixed, 0) ? 0 : M )", (logical_gt(fixed, 0) ? 0 : M ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> SPD_eta((logical_gt(fixed, 0) ? 0 : M ));
            stan::math::initialize(SPD_eta, DUMMY_VAR__);
            stan::math::fill(SPD_eta, DUMMY_VAR__);
            current_statement_begin__ = 158;
            int rt_break_count(0);
            (void) rt_break_count;  // dummy to suppress unused var warning
            stan::math::fill(rt_break_count, std::numeric_limits<int>::min());
            current_statement_begin__ = 161;
            if (as_bool(logical_negation(fixed))) {
                current_statement_begin__ = 162;
                for (int m = 1; m <= M; ++m) {
                    current_statement_begin__ = 163;
                    stan::model::assign(diagSPD, 
                                stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list()), 
                                stan::math::sqrt(spd_SE(get_base1(alpha, 1, "alpha", 1), get_base1(rho, 1, "rho", 1), stan::math::sqrt(lambda(L, m, pstream__)), pstream__)), 
                                "assigning variable diagSPD");
                }
                current_statement_begin__ = 165;
                stan::math::assign(SPD_eta, elt_multiply(diagSPD, eta));
                current_statement_begin__ = 167;
                stan::math::assign(noise, rep_vector(1e-5, noise_terms));
                current_statement_begin__ = 168;
                stan::math::assign(noise, add(noise, stan::math::exp(multiply(stan::model::rvalue(PHI, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "PHI"), SPD_eta))));
            }
            current_statement_begin__ = 172;
            stan::math::assign(infections, rep_vector(1e-5, t));
            current_statement_begin__ = 175;
            if (as_bool(estimate_r)) {
                current_statement_begin__ = 177;
                for (int j = 1; j <= max_gt; ++j) {
                    current_statement_begin__ = 178;
                    stan::model::assign(rev_generation_time, 
                                stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                discretised_gamma_pmf(((max_gt - j) + 1), get_base1(gt_mean, estimate_r, "gt_mean", 1), get_base1(gt_sd, estimate_r, "gt_sd", 1), max_gt, pstream__), 
                                "assigning variable rev_generation_time");
                }
                current_statement_begin__ = 183;
                stan::math::assign(rt_break_count, 0);
                current_statement_begin__ = 185;
                if (as_bool(stationary)) {
                    current_statement_begin__ = 186;
                    stan::math::assign(R, rep_vector(get_base1(initial_R, estimate_r, "initial_R", 1), rt));
                    current_statement_begin__ = 187;
                    for (int s = 1; s <= rt; ++s) {
                        current_statement_begin__ = 188;
                        if (as_bool(logical_negation(fixed))) {
                            current_statement_begin__ = 189;
                            if (as_bool((primitive_value(logical_negation(future_fixed)) || primitive_value(logical_lte(s, noise_terms))))) {
                                current_statement_begin__ = 190;
                                stan::model::assign(R, 
                                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                            (stan::model::rvalue(R, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "R") * get_base1(noise, s, "noise", 1)), 
                                            "assigning variable R");
                            } else {
                                current_statement_begin__ = 192;
                                stan::model::assign(R, 
                                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                            get_base1(R, (s - 1), "R", 1), 
                                            "assigning variable R");
                            }
                        }
                        current_statement_begin__ = 197;
                        if (as_bool(logical_gt(break_no, 0))) {
                            current_statement_begin__ = 198;
                            stan::math::assign(rt_break_count, (rt_break_count + get_base1(breakpoints, s, "breakpoints", 1)));
                            current_statement_begin__ = 199;
                            if (as_bool(logical_gt(rt_break_count, 0))) {
                                current_statement_begin__ = 200;
                                stan::model::assign(R, 
                                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                            (get_base1(R, s, "R", 1) * prod(stan::model::rvalue(rt_break_eff, stan::model::cons_list(stan::model::index_min_max(1, rt_break_count), stan::model::nil_index_list()), "rt_break_eff"))), 
                                            "assigning variable R");
                            }
                        }
                    }
                } else {
                    current_statement_begin__ = 206;
                    stan::model::assign(R, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                get_base1(initial_R, estimate_r, "initial_R", 1), 
                                "assigning variable R");
                    current_statement_begin__ = 207;
                    for (int s = 2; s <= rt; ++s) {
                        current_statement_begin__ = 208;
                        if (as_bool((primitive_value(logical_negation(future_fixed)) || primitive_value(logical_lte(s, (noise_terms + 1)))))) {
                            current_statement_begin__ = 209;
                            stan::model::assign(R, 
                                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                        (get_base1(R, (s - 1), "R", 1) * get_base1(noise, (s - 1), "noise", 1)), 
                                        "assigning variable R");
                        } else {
                            current_statement_begin__ = 211;
                            stan::model::assign(R, 
                                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                        get_base1(R, (s - 1), "R", 1), 
                                        "assigning variable R");
                        }
                        current_statement_begin__ = 215;
                        if (as_bool(logical_gt(break_no, 0))) {
                            current_statement_begin__ = 216;
                            if (as_bool(logical_eq(get_base1(breakpoints, s, "breakpoints", 1), 1))) {
                                current_statement_begin__ = 217;
                                stan::math::assign(rt_break_count, sum(stan::model::rvalue(breakpoints, stan::model::cons_list(stan::model::index_min_max(1, s), stan::model::nil_index_list()), "breakpoints")));
                                current_statement_begin__ = 218;
                                stan::model::assign(R, 
                                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                            (get_base1(R, s, "R", 1) * get_base1(rt_break_eff, rt_break_count, "rt_break_eff", 1)), 
                                            "assigning variable R");
                            }
                        }
                    }
                }
                current_statement_begin__ = 225;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_min_max(1, no_rt_time), stan::model::nil_index_list()), 
                            stan::model::deep_copy(add(stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max(1, no_rt_time), stan::model::nil_index_list()), "infections"), elt_multiply(stan::model::rvalue(shifted_cases, stan::model::cons_list(stan::model::index_min_max(1, no_rt_time), stan::model::nil_index_list()), "shifted_cases"), stan::math::exp(initial_infections)))), 
                            "assigning variable infections");
                current_statement_begin__ = 229;
                stan::math::assign(infectiousness, rep_vector(1e-5, rt));
                current_statement_begin__ = 230;
                for (int s = 1; s <= rt; ++s) {
                    current_statement_begin__ = 231;
                    stan::model::assign(infectiousness, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                (stan::model::rvalue(infectiousness, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "infectiousness") + dot_product(stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max(std::max(1, ((s + no_rt_time) - max_gt)), ((s + no_rt_time) - 1)), stan::model::nil_index_list()), "infections"), tail(rev_generation_time, std::min(max_gt, ((s + no_rt_time) - 1))))), 
                                "assigning variable infectiousness");
                    current_statement_begin__ = 233;
                    stan::model::assign(infections, 
                                stan::model::cons_list(stan::model::index_uni((s + no_rt_time)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_uni((s + no_rt_time)), stan::model::nil_index_list()), "infections") + (get_base1(R, s, "R", 1) * get_base1(infectiousness, s, "infectiousness", 1))), 
                                "assigning variable infections");
                }
            } else {
                current_statement_begin__ = 237;
                if (as_bool(logical_negation(fixed))) {
                    current_statement_begin__ = 238;
                    stan::math::assign(infections, add(infections, elt_multiply(shifted_cases, noise)));
                } else {
                    current_statement_begin__ = 240;
                    stan::math::assign(infections, add(infections, shifted_cases));
                }
            }
            current_statement_begin__ = 246;
            if (as_bool(delays)) {
                {
                current_statement_begin__ = 248;
                validate_non_negative_index("reports_hold", "t", t);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reports_hold(t);
                stan::math::initialize(reports_hold, DUMMY_VAR__);
                stan::math::fill(reports_hold, DUMMY_VAR__);
                current_statement_begin__ = 249;
                for (int s = 1; s <= delays; ++s) {
                    {
                    current_statement_begin__ = 251;
                    validate_non_negative_index("rev_delay", "get_base1(max_delay, s, \"max_delay\", 1)", get_base1(max_delay, s, "max_delay", 1));
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev_delay(get_base1(max_delay, s, "max_delay", 1));
                    stan::math::initialize(rev_delay, DUMMY_VAR__);
                    stan::math::fill(rev_delay, DUMMY_VAR__);
                    stan::math::assign(rev_delay,rep_vector(1e-5, get_base1(max_delay, s, "max_delay", 1)));
                    current_statement_begin__ = 252;
                    for (int j = 1; j <= get_base1(max_delay, s, "max_delay", 1); ++j) {
                        current_statement_begin__ = 253;
                        stan::model::assign(rev_delay, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(rev_delay, stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), "rev_delay") + discretised_lognormal_pmf(((get_base1(max_delay, s, "max_delay", 1) - j) + 1), get_base1(delay_mean, s, "delay_mean", 1), get_base1(delay_sd, s, "delay_sd", 1), get_base1(max_delay, s, "max_delay", 1), pstream__)), 
                                    "assigning variable rev_delay");
                    }
                    current_statement_begin__ = 256;
                    if (as_bool(logical_eq(s, 1))) {
                        current_statement_begin__ = 257;
                        stan::math::assign(reports_hold, convolve(infections, rev_delay, pstream__));
                    } else {
                        current_statement_begin__ = 259;
                        stan::math::assign(reports_hold, convolve(reports_hold, rev_delay, pstream__));
                    }
                    }
                }
                current_statement_begin__ = 262;
                stan::math::assign(reports, stan::model::rvalue(reports_hold, stan::model::cons_list(stan::model::index_min_max((no_rt_time + 1), t), stan::model::nil_index_list()), "reports_hold"));
                }
            } else {
                current_statement_begin__ = 265;
                stan::math::assign(reports, stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max((no_rt_time + 1), t), stan::model::nil_index_list()), "infections"));
            }
            current_statement_begin__ = 269;
            if (as_bool(est_week_eff)) {
                current_statement_begin__ = 271;
                stan::math::assign(day_of_week_eff, multiply(7, day_of_week_eff_raw));
                current_statement_begin__ = 273;
                for (int s = 1; s <= rt; ++s) {
                    current_statement_begin__ = 275;
                    stan::model::assign(reports, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                (stan::model::rvalue(reports, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "reports") * get_base1(day_of_week_eff, get_base1(day_of_week, s, "day_of_week", 1), "day_of_week_eff", 1)), 
                                "assigning variable reports");
                }
            }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 147;
            size_t noise_j_1_max__ = (fixed ? 0 : noise_terms );
            for (size_t j_1__ = 0; j_1__ < noise_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(noise(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: noise" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable noise: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 148;
            size_t infections_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(infections(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: infections" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable infections: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 149;
            size_t reports_j_1_max__ = rt;
            for (size_t j_1__ = 0; j_1__ < reports_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(reports(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: reports" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable reports: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 150;
            size_t day_of_week_eff_j_1_max__ = (est_week_eff ? 7 : 0 );
            for (size_t j_1__ = 0; j_1__ < day_of_week_eff_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(day_of_week_eff(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: day_of_week_eff" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable day_of_week_eff: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 151;
            size_t R_j_1_max__ = (logical_gt(estimate_r, 0) ? rt : 0 );
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(R(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: R" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable R: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 283;
            if (as_bool(logical_negation(fixed))) {
                current_statement_begin__ = 284;
                lp_accum__.add(normal_log<propto__>(rho, lengthscale_mean, lengthscale_sd));
                current_statement_begin__ = 285;
                lp_accum__.add(normal_log<propto__>(alpha, 0, 0.1));
                current_statement_begin__ = 286;
                lp_accum__.add(std_normal_log<propto__>(eta));
            }
            current_statement_begin__ = 290;
            if (as_bool(model_type)) {
                current_statement_begin__ = 291;
                lp_accum__.add(exponential_log<propto__>(get_base1(rep_phi, model_type, "rep_phi", 1), 1));
            }
            current_statement_begin__ = 295;
            if (as_bool(delays)) {
                current_statement_begin__ = 296;
                for (int s = 1; s <= delays; ++s) {
                    current_statement_begin__ = 297;
                    lp_accum__.add((normal_log(get_base1(delay_mean, s, "delay_mean", 1), get_base1(delay_mean_mean, s, "delay_mean_mean", 1), get_base1(delay_mean_sd, s, "delay_mean_sd", 1)) * t));
                    current_statement_begin__ = 298;
                    lp_accum__.add((normal_log(get_base1(delay_sd, s, "delay_sd", 1), get_base1(delay_sd_mean, s, "delay_sd_mean", 1), get_base1(delay_sd_sd, s, "delay_sd_sd", 1)) * t));
                }
            }
            current_statement_begin__ = 303;
            if (as_bool(estimate_r)) {
                current_statement_begin__ = 305;
                lp_accum__.add(gamma_log<propto__>(get_base1(initial_R, estimate_r, "initial_R", 1), r_alpha, r_beta));
                current_statement_begin__ = 306;
                lp_accum__.add(normal_log<propto__>(initial_infections, 0, 0.1));
                current_statement_begin__ = 309;
                lp_accum__.add((normal_log(gt_mean, gt_mean_mean, gt_mean_sd) * rt));
                current_statement_begin__ = 310;
                lp_accum__.add((normal_log(gt_sd, gt_sd_mean, gt_sd_sd) * rt));
                current_statement_begin__ = 313;
                if (as_bool(logical_gt(break_no, 0))) {
                    current_statement_begin__ = 314;
                    lp_accum__.add(lognormal_log<propto__>(rt_break_eff, 0, 0.1));
                }
            }
            current_statement_begin__ = 319;
            if (as_bool(model_type)) {
                current_statement_begin__ = 320;
                lp_accum__.add(neg_binomial_2_log(cases, stan::model::rvalue(reports, stan::model::cons_list(stan::model::index_min_max(1, rt_h), stan::model::nil_index_list()), "reports"), get_base1(rep_phi, model_type, "rep_phi", 1)));
            } else {
                current_statement_begin__ = 322;
                lp_accum__.add(poisson_log(cases, stan::model::rvalue(reports, stan::model::cons_list(stan::model::index_min_max(1, rt_h), stan::model::nil_index_list()), "reports")));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("day_of_week_eff_raw");
        names__.push_back("delay_mean");
        names__.push_back("delay_sd");
        names__.push_back("rep_phi");
        names__.push_back("rho");
        names__.push_back("alpha");
        names__.push_back("eta");
        names__.push_back("initial_R");
        names__.push_back("initial_infections");
        names__.push_back("gt_mean");
        names__.push_back("gt_sd");
        names__.push_back("rt_break_eff");
        names__.push_back("noise");
        names__.push_back("infections");
        names__.push_back("reports");
        names__.push_back("day_of_week_eff");
        names__.push_back("R");
        names__.push_back("imputed_reports");
        names__.push_back("r");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((est_week_eff ? 7 : 1 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(delays);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(delays);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(model_type);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((fixed ? 0 : 1 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((fixed ? 0 : 1 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((fixed ? 0 : M ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(estimate_r);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(estimate_r, 0) ? no_rt_time : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(estimate_r);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(estimate_r);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(break_no);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((fixed ? 0 : noise_terms ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(rt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((est_week_eff ? 7 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(estimate_r, 0) ? rt : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(rt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(estimate_r, 0) ? rt : 0 ));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_estimate_infections_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> day_of_week_eff_raw = in__.simplex_constrain((est_week_eff ? 7 : 1 ));
        size_t day_of_week_eff_raw_j_1_max__ = (est_week_eff ? 7 : 1 );
        for (size_t j_1__ = 0; j_1__ < day_of_week_eff_raw_j_1_max__; ++j_1__) {
            vars__.push_back(day_of_week_eff_raw(j_1__));
        }
        std::vector<double> delay_mean;
        size_t delay_mean_d_0_max__ = delays;
        delay_mean.reserve(delay_mean_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < delay_mean_d_0_max__; ++d_0__) {
            delay_mean.push_back(in__.scalar_lb_constrain(0));
        }
        size_t delay_mean_k_0_max__ = delays;
        for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
            vars__.push_back(delay_mean[k_0__]);
        }
        std::vector<double> delay_sd;
        size_t delay_sd_d_0_max__ = delays;
        delay_sd.reserve(delay_sd_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < delay_sd_d_0_max__; ++d_0__) {
            delay_sd.push_back(in__.scalar_lb_constrain(0));
        }
        size_t delay_sd_k_0_max__ = delays;
        for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
            vars__.push_back(delay_sd[k_0__]);
        }
        std::vector<double> rep_phi;
        size_t rep_phi_d_0_max__ = model_type;
        rep_phi.reserve(rep_phi_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rep_phi_d_0_max__; ++d_0__) {
            rep_phi.push_back(in__.scalar_lb_constrain(0));
        }
        size_t rep_phi_k_0_max__ = model_type;
        for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
            vars__.push_back(rep_phi[k_0__]);
        }
        std::vector<double> rho;
        size_t rho_d_0_max__ = (fixed ? 0 : 1 );
        rho.reserve(rho_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rho_d_0_max__; ++d_0__) {
            rho.push_back(in__.scalar_lb_constrain(0));
        }
        size_t rho_k_0_max__ = (fixed ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            vars__.push_back(rho[k_0__]);
        }
        std::vector<double> alpha;
        size_t alpha_d_0_max__ = (fixed ? 0 : 1 );
        alpha.reserve(alpha_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
            alpha.push_back(in__.scalar_lb_constrain(0));
        }
        size_t alpha_k_0_max__ = (fixed ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta = in__.vector_constrain((fixed ? 0 : M ));
        size_t eta_j_1_max__ = (fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            vars__.push_back(eta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> initial_R = in__.vector_constrain(estimate_r);
        size_t initial_R_j_1_max__ = estimate_r;
        for (size_t j_1__ = 0; j_1__ < initial_R_j_1_max__; ++j_1__) {
            vars__.push_back(initial_R(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> initial_infections = in__.vector_constrain((logical_gt(estimate_r, 0) ? no_rt_time : 0 ));
        size_t initial_infections_j_1_max__ = (logical_gt(estimate_r, 0) ? no_rt_time : 0 );
        for (size_t j_1__ = 0; j_1__ < initial_infections_j_1_max__; ++j_1__) {
            vars__.push_back(initial_infections(j_1__));
        }
        std::vector<double> gt_mean;
        size_t gt_mean_d_0_max__ = estimate_r;
        gt_mean.reserve(gt_mean_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < gt_mean_d_0_max__; ++d_0__) {
            gt_mean.push_back(in__.scalar_lb_constrain(0));
        }
        size_t gt_mean_k_0_max__ = estimate_r;
        for (size_t k_0__ = 0; k_0__ < gt_mean_k_0_max__; ++k_0__) {
            vars__.push_back(gt_mean[k_0__]);
        }
        std::vector<double> gt_sd;
        size_t gt_sd_d_0_max__ = estimate_r;
        gt_sd.reserve(gt_sd_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < gt_sd_d_0_max__; ++d_0__) {
            gt_sd.push_back(in__.scalar_lb_constrain(0));
        }
        size_t gt_sd_k_0_max__ = estimate_r;
        for (size_t k_0__ = 0; k_0__ < gt_sd_k_0_max__; ++k_0__) {
            vars__.push_back(gt_sd[k_0__]);
        }
        std::vector<double> rt_break_eff;
        size_t rt_break_eff_d_0_max__ = break_no;
        rt_break_eff.reserve(rt_break_eff_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rt_break_eff_d_0_max__; ++d_0__) {
            rt_break_eff.push_back(in__.scalar_constrain());
        }
        size_t rt_break_eff_k_0_max__ = break_no;
        for (size_t k_0__ = 0; k_0__ < rt_break_eff_k_0_max__; ++k_0__) {
            vars__.push_back(rt_break_eff[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 147;
            validate_non_negative_index("noise", "(fixed ? 0 : noise_terms )", (fixed ? 0 : noise_terms ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> noise((fixed ? 0 : noise_terms ));
            stan::math::initialize(noise, DUMMY_VAR__);
            stan::math::fill(noise, DUMMY_VAR__);
            current_statement_begin__ = 148;
            validate_non_negative_index("infections", "t", t);
            Eigen::Matrix<double, Eigen::Dynamic, 1> infections(t);
            stan::math::initialize(infections, DUMMY_VAR__);
            stan::math::fill(infections, DUMMY_VAR__);
            current_statement_begin__ = 149;
            validate_non_negative_index("reports", "rt", rt);
            Eigen::Matrix<double, Eigen::Dynamic, 1> reports(rt);
            stan::math::initialize(reports, DUMMY_VAR__);
            stan::math::fill(reports, DUMMY_VAR__);
            current_statement_begin__ = 150;
            validate_non_negative_index("day_of_week_eff", "(est_week_eff ? 7 : 0 )", (est_week_eff ? 7 : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> day_of_week_eff((est_week_eff ? 7 : 0 ));
            stan::math::initialize(day_of_week_eff, DUMMY_VAR__);
            stan::math::fill(day_of_week_eff, DUMMY_VAR__);
            current_statement_begin__ = 151;
            validate_non_negative_index("R", "(logical_gt(estimate_r, 0) ? rt : 0 )", (logical_gt(estimate_r, 0) ? rt : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> R((logical_gt(estimate_r, 0) ? rt : 0 ));
            stan::math::initialize(R, DUMMY_VAR__);
            stan::math::fill(R, DUMMY_VAR__);
            // do transformed parameters statements
            {
            current_statement_begin__ = 154;
            validate_non_negative_index("rev_generation_time", "(logical_gt(estimate_r, 0) ? max_gt : 0 )", (logical_gt(estimate_r, 0) ? max_gt : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev_generation_time((logical_gt(estimate_r, 0) ? max_gt : 0 ));
            stan::math::initialize(rev_generation_time, DUMMY_VAR__);
            stan::math::fill(rev_generation_time, DUMMY_VAR__);
            current_statement_begin__ = 155;
            validate_non_negative_index("infectiousness", "(logical_gt(estimate_r, 0) ? rt : 0 )", (logical_gt(estimate_r, 0) ? rt : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> infectiousness((logical_gt(estimate_r, 0) ? rt : 0 ));
            stan::math::initialize(infectiousness, DUMMY_VAR__);
            stan::math::fill(infectiousness, DUMMY_VAR__);
            current_statement_begin__ = 156;
            validate_non_negative_index("diagSPD", "(logical_gt(fixed, 0) ? 0 : M )", (logical_gt(fixed, 0) ? 0 : M ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> diagSPD((logical_gt(fixed, 0) ? 0 : M ));
            stan::math::initialize(diagSPD, DUMMY_VAR__);
            stan::math::fill(diagSPD, DUMMY_VAR__);
            current_statement_begin__ = 157;
            validate_non_negative_index("SPD_eta", "(logical_gt(fixed, 0) ? 0 : M )", (logical_gt(fixed, 0) ? 0 : M ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> SPD_eta((logical_gt(fixed, 0) ? 0 : M ));
            stan::math::initialize(SPD_eta, DUMMY_VAR__);
            stan::math::fill(SPD_eta, DUMMY_VAR__);
            current_statement_begin__ = 158;
            int rt_break_count(0);
            (void) rt_break_count;  // dummy to suppress unused var warning
            stan::math::fill(rt_break_count, std::numeric_limits<int>::min());
            current_statement_begin__ = 161;
            if (as_bool(logical_negation(fixed))) {
                current_statement_begin__ = 162;
                for (int m = 1; m <= M; ++m) {
                    current_statement_begin__ = 163;
                    stan::model::assign(diagSPD, 
                                stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list()), 
                                stan::math::sqrt(spd_SE(get_base1(alpha, 1, "alpha", 1), get_base1(rho, 1, "rho", 1), stan::math::sqrt(lambda(L, m, pstream__)), pstream__)), 
                                "assigning variable diagSPD");
                }
                current_statement_begin__ = 165;
                stan::math::assign(SPD_eta, elt_multiply(diagSPD, eta));
                current_statement_begin__ = 167;
                stan::math::assign(noise, rep_vector(1e-5, noise_terms));
                current_statement_begin__ = 168;
                stan::math::assign(noise, add(noise, stan::math::exp(multiply(stan::model::rvalue(PHI, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "PHI"), SPD_eta))));
            }
            current_statement_begin__ = 172;
            stan::math::assign(infections, rep_vector(1e-5, t));
            current_statement_begin__ = 175;
            if (as_bool(estimate_r)) {
                current_statement_begin__ = 177;
                for (int j = 1; j <= max_gt; ++j) {
                    current_statement_begin__ = 178;
                    stan::model::assign(rev_generation_time, 
                                stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                discretised_gamma_pmf(((max_gt - j) + 1), get_base1(gt_mean, estimate_r, "gt_mean", 1), get_base1(gt_sd, estimate_r, "gt_sd", 1), max_gt, pstream__), 
                                "assigning variable rev_generation_time");
                }
                current_statement_begin__ = 183;
                stan::math::assign(rt_break_count, 0);
                current_statement_begin__ = 185;
                if (as_bool(stationary)) {
                    current_statement_begin__ = 186;
                    stan::math::assign(R, rep_vector(get_base1(initial_R, estimate_r, "initial_R", 1), rt));
                    current_statement_begin__ = 187;
                    for (int s = 1; s <= rt; ++s) {
                        current_statement_begin__ = 188;
                        if (as_bool(logical_negation(fixed))) {
                            current_statement_begin__ = 189;
                            if (as_bool((primitive_value(logical_negation(future_fixed)) || primitive_value(logical_lte(s, noise_terms))))) {
                                current_statement_begin__ = 190;
                                stan::model::assign(R, 
                                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                            (stan::model::rvalue(R, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "R") * get_base1(noise, s, "noise", 1)), 
                                            "assigning variable R");
                            } else {
                                current_statement_begin__ = 192;
                                stan::model::assign(R, 
                                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                            get_base1(R, (s - 1), "R", 1), 
                                            "assigning variable R");
                            }
                        }
                        current_statement_begin__ = 197;
                        if (as_bool(logical_gt(break_no, 0))) {
                            current_statement_begin__ = 198;
                            stan::math::assign(rt_break_count, (rt_break_count + get_base1(breakpoints, s, "breakpoints", 1)));
                            current_statement_begin__ = 199;
                            if (as_bool(logical_gt(rt_break_count, 0))) {
                                current_statement_begin__ = 200;
                                stan::model::assign(R, 
                                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                            (get_base1(R, s, "R", 1) * prod(stan::model::rvalue(rt_break_eff, stan::model::cons_list(stan::model::index_min_max(1, rt_break_count), stan::model::nil_index_list()), "rt_break_eff"))), 
                                            "assigning variable R");
                            }
                        }
                    }
                } else {
                    current_statement_begin__ = 206;
                    stan::model::assign(R, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                get_base1(initial_R, estimate_r, "initial_R", 1), 
                                "assigning variable R");
                    current_statement_begin__ = 207;
                    for (int s = 2; s <= rt; ++s) {
                        current_statement_begin__ = 208;
                        if (as_bool((primitive_value(logical_negation(future_fixed)) || primitive_value(logical_lte(s, (noise_terms + 1)))))) {
                            current_statement_begin__ = 209;
                            stan::model::assign(R, 
                                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                        (get_base1(R, (s - 1), "R", 1) * get_base1(noise, (s - 1), "noise", 1)), 
                                        "assigning variable R");
                        } else {
                            current_statement_begin__ = 211;
                            stan::model::assign(R, 
                                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                        get_base1(R, (s - 1), "R", 1), 
                                        "assigning variable R");
                        }
                        current_statement_begin__ = 215;
                        if (as_bool(logical_gt(break_no, 0))) {
                            current_statement_begin__ = 216;
                            if (as_bool(logical_eq(get_base1(breakpoints, s, "breakpoints", 1), 1))) {
                                current_statement_begin__ = 217;
                                stan::math::assign(rt_break_count, sum(stan::model::rvalue(breakpoints, stan::model::cons_list(stan::model::index_min_max(1, s), stan::model::nil_index_list()), "breakpoints")));
                                current_statement_begin__ = 218;
                                stan::model::assign(R, 
                                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                            (get_base1(R, s, "R", 1) * get_base1(rt_break_eff, rt_break_count, "rt_break_eff", 1)), 
                                            "assigning variable R");
                            }
                        }
                    }
                }
                current_statement_begin__ = 225;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_min_max(1, no_rt_time), stan::model::nil_index_list()), 
                            stan::model::deep_copy(add(stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max(1, no_rt_time), stan::model::nil_index_list()), "infections"), elt_multiply(stan::model::rvalue(shifted_cases, stan::model::cons_list(stan::model::index_min_max(1, no_rt_time), stan::model::nil_index_list()), "shifted_cases"), stan::math::exp(initial_infections)))), 
                            "assigning variable infections");
                current_statement_begin__ = 229;
                stan::math::assign(infectiousness, rep_vector(1e-5, rt));
                current_statement_begin__ = 230;
                for (int s = 1; s <= rt; ++s) {
                    current_statement_begin__ = 231;
                    stan::model::assign(infectiousness, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                (stan::model::rvalue(infectiousness, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "infectiousness") + dot_product(stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max(std::max(1, ((s + no_rt_time) - max_gt)), ((s + no_rt_time) - 1)), stan::model::nil_index_list()), "infections"), tail(rev_generation_time, std::min(max_gt, ((s + no_rt_time) - 1))))), 
                                "assigning variable infectiousness");
                    current_statement_begin__ = 233;
                    stan::model::assign(infections, 
                                stan::model::cons_list(stan::model::index_uni((s + no_rt_time)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_uni((s + no_rt_time)), stan::model::nil_index_list()), "infections") + (get_base1(R, s, "R", 1) * get_base1(infectiousness, s, "infectiousness", 1))), 
                                "assigning variable infections");
                }
            } else {
                current_statement_begin__ = 237;
                if (as_bool(logical_negation(fixed))) {
                    current_statement_begin__ = 238;
                    stan::math::assign(infections, add(infections, elt_multiply(shifted_cases, noise)));
                } else {
                    current_statement_begin__ = 240;
                    stan::math::assign(infections, add(infections, shifted_cases));
                }
            }
            current_statement_begin__ = 246;
            if (as_bool(delays)) {
                {
                current_statement_begin__ = 248;
                validate_non_negative_index("reports_hold", "t", t);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reports_hold(t);
                stan::math::initialize(reports_hold, DUMMY_VAR__);
                stan::math::fill(reports_hold, DUMMY_VAR__);
                current_statement_begin__ = 249;
                for (int s = 1; s <= delays; ++s) {
                    {
                    current_statement_begin__ = 251;
                    validate_non_negative_index("rev_delay", "get_base1(max_delay, s, \"max_delay\", 1)", get_base1(max_delay, s, "max_delay", 1));
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev_delay(get_base1(max_delay, s, "max_delay", 1));
                    stan::math::initialize(rev_delay, DUMMY_VAR__);
                    stan::math::fill(rev_delay, DUMMY_VAR__);
                    stan::math::assign(rev_delay,rep_vector(1e-5, get_base1(max_delay, s, "max_delay", 1)));
                    current_statement_begin__ = 252;
                    for (int j = 1; j <= get_base1(max_delay, s, "max_delay", 1); ++j) {
                        current_statement_begin__ = 253;
                        stan::model::assign(rev_delay, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(rev_delay, stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), "rev_delay") + discretised_lognormal_pmf(((get_base1(max_delay, s, "max_delay", 1) - j) + 1), get_base1(delay_mean, s, "delay_mean", 1), get_base1(delay_sd, s, "delay_sd", 1), get_base1(max_delay, s, "max_delay", 1), pstream__)), 
                                    "assigning variable rev_delay");
                    }
                    current_statement_begin__ = 256;
                    if (as_bool(logical_eq(s, 1))) {
                        current_statement_begin__ = 257;
                        stan::math::assign(reports_hold, convolve(infections, rev_delay, pstream__));
                    } else {
                        current_statement_begin__ = 259;
                        stan::math::assign(reports_hold, convolve(reports_hold, rev_delay, pstream__));
                    }
                    }
                }
                current_statement_begin__ = 262;
                stan::math::assign(reports, stan::model::rvalue(reports_hold, stan::model::cons_list(stan::model::index_min_max((no_rt_time + 1), t), stan::model::nil_index_list()), "reports_hold"));
                }
            } else {
                current_statement_begin__ = 265;
                stan::math::assign(reports, stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max((no_rt_time + 1), t), stan::model::nil_index_list()), "infections"));
            }
            current_statement_begin__ = 269;
            if (as_bool(est_week_eff)) {
                current_statement_begin__ = 271;
                stan::math::assign(day_of_week_eff, multiply(7, day_of_week_eff_raw));
                current_statement_begin__ = 273;
                for (int s = 1; s <= rt; ++s) {
                    current_statement_begin__ = 275;
                    stan::model::assign(reports, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                (stan::model::rvalue(reports, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "reports") * get_base1(day_of_week_eff, get_base1(day_of_week, s, "day_of_week", 1), "day_of_week_eff", 1)), 
                                "assigning variable reports");
                }
            }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t noise_j_1_max__ = (fixed ? 0 : noise_terms );
                for (size_t j_1__ = 0; j_1__ < noise_j_1_max__; ++j_1__) {
                    vars__.push_back(noise(j_1__));
                }
                size_t infections_j_1_max__ = t;
                for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                    vars__.push_back(infections(j_1__));
                }
                size_t reports_j_1_max__ = rt;
                for (size_t j_1__ = 0; j_1__ < reports_j_1_max__; ++j_1__) {
                    vars__.push_back(reports(j_1__));
                }
                size_t day_of_week_eff_j_1_max__ = (est_week_eff ? 7 : 0 );
                for (size_t j_1__ = 0; j_1__ < day_of_week_eff_j_1_max__; ++j_1__) {
                    vars__.push_back(day_of_week_eff(j_1__));
                }
                size_t R_j_1_max__ = (logical_gt(estimate_r, 0) ? rt : 0 );
                for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                    vars__.push_back(R(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 327;
            validate_non_negative_index("imputed_reports", "rt", rt);
            std::vector<int> imputed_reports(rt, int(0));
            stan::math::fill(imputed_reports, std::numeric_limits<int>::min());
            current_statement_begin__ = 328;
            validate_non_negative_index("r", "(logical_gt(estimate_r, 0) ? rt : 0 )", (logical_gt(estimate_r, 0) ? rt : 0 ));
            std::vector<double> r((logical_gt(estimate_r, 0) ? rt : 0 ), double(0));
            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 331;
            if (as_bool(estimate_r)) {
                {
                current_statement_begin__ = 332;
                local_scalar_t__ k(DUMMY_VAR__);
                (void) k;  // dummy to suppress unused var warning
                stan::math::initialize(k, DUMMY_VAR__);
                stan::math::fill(k, DUMMY_VAR__);
                stan::math::assign(k,pow((get_base1(gt_sd, estimate_r, "gt_sd", 1) / get_base1(gt_mean, estimate_r, "gt_mean", 1)), 2));
                current_statement_begin__ = 333;
                for (int s = 1; s <= rt; ++s) {
                    current_statement_begin__ = 334;
                    stan::model::assign(r, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                ((pow(get_base1(R, s, "R", 1), k) - 1) / (k * get_base1(gt_mean, estimate_r, "gt_mean", 1))), 
                                "assigning variable r");
                }
                }
            }
            current_statement_begin__ = 339;
            if (as_bool(model_type)) {
                current_statement_begin__ = 340;
                for (int s = 1; s <= rt; ++s) {
                    current_statement_begin__ = 341;
                    stan::model::assign(imputed_reports, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                neg_binomial_2_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e7) ? stan::math::promote_scalar<local_scalar_t__>(1e7) : stan::math::promote_scalar<local_scalar_t__>(get_base1(reports, s, "reports", 1)) ), get_base1(rep_phi, model_type, "rep_phi", 1), base_rng__), 
                                "assigning variable imputed_reports");
                }
            } else {
                current_statement_begin__ = 344;
                for (int s = 1; s <= rt; ++s) {
                    current_statement_begin__ = 345;
                    stan::model::assign(imputed_reports, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                poisson_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? stan::math::promote_scalar<local_scalar_t__>(1e8) : stan::math::promote_scalar<local_scalar_t__>(get_base1(reports, s, "reports", 1)) ), base_rng__), 
                                "assigning variable imputed_reports");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 327;
            size_t imputed_reports_k_0_max__ = rt;
            for (size_t k_0__ = 0; k_0__ < imputed_reports_k_0_max__; ++k_0__) {
                vars__.push_back(imputed_reports[k_0__]);
            }
            current_statement_begin__ = 328;
            size_t r_k_0_max__ = (logical_gt(estimate_r, 0) ? rt : 0 );
            for (size_t k_0__ = 0; k_0__ < r_k_0_max__; ++k_0__) {
                vars__.push_back(r[k_0__]);
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_estimate_infections";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t day_of_week_eff_raw_j_1_max__ = (est_week_eff ? 7 : 1 );
        for (size_t j_1__ = 0; j_1__ < day_of_week_eff_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "day_of_week_eff_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delay_mean_k_0_max__ = delays;
        for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delay_mean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delay_sd_k_0_max__ = delays;
        for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delay_sd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rep_phi_k_0_max__ = model_type;
        for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rep_phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_k_0_max__ = (fixed ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_k_0_max__ = (fixed ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_j_1_max__ = (fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t initial_R_j_1_max__ = estimate_r;
        for (size_t j_1__ = 0; j_1__ < initial_R_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "initial_R" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t initial_infections_j_1_max__ = (logical_gt(estimate_r, 0) ? no_rt_time : 0 );
        for (size_t j_1__ = 0; j_1__ < initial_infections_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "initial_infections" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gt_mean_k_0_max__ = estimate_r;
        for (size_t k_0__ = 0; k_0__ < gt_mean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gt_mean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gt_sd_k_0_max__ = estimate_r;
        for (size_t k_0__ = 0; k_0__ < gt_sd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gt_sd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rt_break_eff_k_0_max__ = break_no;
        for (size_t k_0__ = 0; k_0__ < rt_break_eff_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rt_break_eff" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t noise_j_1_max__ = (fixed ? 0 : noise_terms );
            for (size_t j_1__ = 0; j_1__ < noise_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "noise" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t infections_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "infections" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t reports_j_1_max__ = rt;
            for (size_t j_1__ = 0; j_1__ < reports_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reports" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t day_of_week_eff_j_1_max__ = (est_week_eff ? 7 : 0 );
            for (size_t j_1__ = 0; j_1__ < day_of_week_eff_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "day_of_week_eff" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t R_j_1_max__ = (logical_gt(estimate_r, 0) ? rt : 0 );
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t imputed_reports_k_0_max__ = rt;
        for (size_t k_0__ = 0; k_0__ < imputed_reports_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "imputed_reports" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t r_k_0_max__ = (logical_gt(estimate_r, 0) ? rt : 0 );
        for (size_t k_0__ = 0; k_0__ < r_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t day_of_week_eff_raw_j_1_max__ = ((est_week_eff ? 7 : 1 ) - 1);
        for (size_t j_1__ = 0; j_1__ < day_of_week_eff_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "day_of_week_eff_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delay_mean_k_0_max__ = delays;
        for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delay_mean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delay_sd_k_0_max__ = delays;
        for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delay_sd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rep_phi_k_0_max__ = model_type;
        for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rep_phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rho_k_0_max__ = (fixed ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < rho_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_k_0_max__ = (fixed ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_j_1_max__ = (fixed ? 0 : M );
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t initial_R_j_1_max__ = estimate_r;
        for (size_t j_1__ = 0; j_1__ < initial_R_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "initial_R" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t initial_infections_j_1_max__ = (logical_gt(estimate_r, 0) ? no_rt_time : 0 );
        for (size_t j_1__ = 0; j_1__ < initial_infections_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "initial_infections" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gt_mean_k_0_max__ = estimate_r;
        for (size_t k_0__ = 0; k_0__ < gt_mean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gt_mean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gt_sd_k_0_max__ = estimate_r;
        for (size_t k_0__ = 0; k_0__ < gt_sd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gt_sd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rt_break_eff_k_0_max__ = break_no;
        for (size_t k_0__ = 0; k_0__ < rt_break_eff_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rt_break_eff" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t noise_j_1_max__ = (fixed ? 0 : noise_terms );
            for (size_t j_1__ = 0; j_1__ < noise_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "noise" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t infections_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "infections" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t reports_j_1_max__ = rt;
            for (size_t j_1__ = 0; j_1__ < reports_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reports" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t day_of_week_eff_j_1_max__ = (est_week_eff ? 7 : 0 );
            for (size_t j_1__ = 0; j_1__ < day_of_week_eff_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "day_of_week_eff" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t R_j_1_max__ = (logical_gt(estimate_r, 0) ? rt : 0 );
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t imputed_reports_k_0_max__ = rt;
        for (size_t k_0__ = 0; k_0__ < imputed_reports_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "imputed_reports" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t r_k_0_max__ = (logical_gt(estimate_r, 0) ? rt : 0 );
        for (size_t k_0__ = 0; k_0__ < r_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_estimate_infections_namespace::model_estimate_infections stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
