% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{rt_opts}
\alias{rt_opts}
\title{Time-Varying Reproduction Number Options}
\usage{
rt_opts(
  prior = list(mean = 1, sd = 1),
  use_rt = TRUE,
  rw = 0,
  use_breakpoints = TRUE,
  future = "latest",
  gp_on = "R_t-1",
  pop = 0
)
}
\arguments{
\item{prior}{List containing named numeric elements "mean" and "sd". The
mean and standard deviation of the log normal Rt prior. Defaults to mean of
1 and standard deviation of 1.}

\item{use_rt}{Logical, defaults to \code{TRUE}. Should Rt be used to generate
infections and hence reported cases.}

\item{rw}{Numeric step size of the random walk, defaults to 0. To specify a
weekly random walk set \code{rw = 7}. For more custom break point settings
consider passing in a \code{breakpoints} variable as outlined in the next section.}

\item{use_breakpoints}{Logical, defaults to \code{TRUE}. Should break points be
used if present as a \code{breakpoint} variable in the input data. Break points
should be defined as 1 if present and otherwise 0. By default breakpoints
are fit jointly with a global non-parametric effect and so represent a
conservative estimate of break point changes (alter this by setting
\code{gp = NULL}).}

\item{future}{A character string or integer. This argument indicates how to set future Rt values. Supported
options are to project using the Rt model ("project"), to use the latest estimate based on partial data ("latest"),
to use the latest estimate based on data that is over 50\% complete ("estimate"). If an integer is supplied then the Rt estimate
from this many days into the future (or past if negative) past will be used forwards in time.}

\item{gp_on}{Character string, defaulting to  "R_t-1". Indicates how the
Gaussian process, if in use, should be applied to Rt. Currently supported
options are applying the Gaussian process to the last estimated Rt (i.e
Rt = Rt-1 * GP), and applying the Gaussian process to a global mean (i.e Rt
= R0 * GP). Both should produced comparable results when data is not sparse
but the method relying on a global mean will revert to this for real time
estimates, which may not be desirable.}

\item{pop}{Integer, defaults to 0. Susceptible population initially present.
Used to adjust Rt estimates when otherwise fixed based on the proportion of
the population that is susceptible. When set to 0 no population adjustment
is done.}
}
\value{
A list of settings defining the time-varying reproduction number.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Defines a list specifying the optional arguments for the time-varying
reproduction number. Custom settings can be supplied which override the
defaults.
}
\examples{
# default settings
rt_opts()

# add a custom length scale
rt_opts(prior = list(mean = 2, sd = 1))

# add a weekly random walk
rt_opts(rw = 7)
}
\author{
Sam Abbott
}
