% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AER_age_gender_bar.R
\name{plotBar}
\alias{plotBar}
\title{Bar graph}
\usage{
plotBar(
  .data,
  xvar = "XLabel",
  xlabel = "",
  yvar = "YValue",
  ylabel = "",
  fill_color = EcdcColors(col_scale = "qual", n = 1)
)
}
\arguments{
\item{.data}{dataframe containing the variables to plot}

\item{xvar}{character string, name of the variable to plot on the x-axis in quotes
(default \code{"XLabel"})}

\item{xlabel}{character string, label of the x axis}

\item{yvar}{character string, name of the variable to plot on the y-axis in quotes
(default \code{"YValue"})}

\item{ylabel}{character string, label of the y axis}

\item{fill_color}{character string, hexadecimal colour to use in the graph;
(default to ECDC green \code{"#65B32E"}, see EcdcColors(col_scale = "qual", n = 1))}
}
\description{
This function draws a bar graph of the values of variable 'Yvar'
with the categorical variable 'Xvar' on the x-axis. \cr
Expects aggregated data.
}
\examples{

# --- Create dummy data
mydat <- data.frame(AgeGroup = c("0-25", "26-65", "65+"),
                    NumberOfCases = c(54,32,41))

# --- Plot the dummy data
plotBar(mydat,
        xvar = "AgeGroup",
        xlabel = "Age",
        yvar = "NumberOfCases",
        ylabel = "Number of cases")

}
\seealso{
Global function: \code{\link{getAgeGender}}  \cr
Internal function: \code{\link{EcdcColors}} \cr
Required Packages: \code{\link{ggplot2}}
}
\keyword{age}
\keyword{bargraph}
