% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{algoSD}
\alias{algoSD}
\title{Build algo object}
\usage{
algoSD(x.sts, algo = "FarringtonFlexible", timeUnit = "Month", testingPeriod = 5)
}
\arguments{
\item{x.sts}{sts class object (see \code{\link{stsSD}} output)}

\item{algo}{character string containing the name of the algorithm to use.
Options are "FarringtonFlexible" (default) or "GLRNB".}

\item{timeUnit}{character string for the time unit of the time series. Options are "Week" or "Month".}

\item{testingPeriod}{numeric: number of time units (months, weeks) back in time to test the algorithm on
(to detect outbreaks in)}
}
\value{
sts
}
\description{
Build algo object from an sts object class
using either FarringtonFlexible or GLRNB surveillance algorithm
}
\examples{
#-- Setting the parameters to run the report for
input <- list(
disease = "Salmonellosis",
country = "EU-EEA - complete series",
indicator = "Reported cases",
stratification = "Confirmed cases",
unit = "Month",
daterange = c("2010-01-01", "2016-12-31"),
algo = "FarringtonFlexible",
testingperiod = 5
)

#-- Example dataset
dataset <- EpiSignalDetection::SignalData

#-- Filtering on declared input parameters
dataset <- filterAtlasExport(dataset, input)

#-- Aggregating the data by geographical level and time point
dataset <- aggAtlasExport(dataset, input)

#-- Bulding the corresponding sts object
dataset.sts <- stsSD(observedCases = dataset$NumValue,
                     studyPeriod = dataset$StudyPeriod,
                     timeUnit = input$unit,
                     startYM = c(as.numeric(format(as.Date(input$daterange[1], "\%Y-\%m-\%d"), "\%Y")),
                                 as.numeric(format(as.Date(input$daterange[1], "\%Y-\%m-\%d"), "\%m"))))

#-- Building the corresponding algo object
dataset.algo <- algoSD(dataset.sts,
                       algo = input$algo,
                       timeUnit = input$unit,
                       testingPeriod =
                       input$testingperiod)

}
\seealso{
\code{\link{stsSD}} \code{\link{plotSD}}
}
