% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpistemicGameTheory.R
\name{type}
\alias{type}
\title{Finding types that express common belief in rationality for optimal choices}
\usage{
type(A, B, choices.A, choices.B)
}
\arguments{
\item{A}{an nxm matrix representing the reduced payoff matrix of player 1}

\item{B}{an nxm matrix representing the reduced payoff matrix of player 2}

\item{choices.A}{a vector of length n representing the names of player 1's choices}

\item{choices.B}{a vector of length m representing the names of player 2's choices}
}
\value{
Probabilities of the types that expresses common belief in rationality for optimal choices
}
\description{
This function takes the reduced payoff matrices and finds out the probabilities for the types that expresses common belief in rationality for optimal choices.
}
\details{
This function works for the games with two players. It returns infeasible solution for the irrational choices.
}
\examples{
Ar=matrix(c(0,3,2,4,0,2,4,3,0),3,3)
choices.Ar=c("Blue","Green","Red")
Br=matrix(c(5,4,4,3,5,3,2,2,5),3,3)
choices.Br=c("Blue","Green","Red")
type(Ar,Br,choices.Ar,choices.Br)
}
\seealso{
\code{lp}
}
\author{
Bilge Baser
}
