% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_maxlogL.R
\encoding{UTF-8}
\name{bootstrap_maxlogL}
\alias{bootstrap_maxlogL}
\title{Bootstrap computation of standard error for \code{maxlogL} class objects.}
\usage{
bootstrap_maxlogL(object, R = 2000, silent = FALSE, ...)
}
\arguments{
\item{object}{an object of \code{\link{maxlogL}} class whose standard errors
are going to be computed by bootstrap.}

\item{R}{numeric. It is the number of resamples performed with the dataset
in bootstrap computation. Default value is 2000.}

\item{silent}{logical. If TRUE, notifications of \code{bootstrap_maxlogL} are suppressed.}

\item{...}{arguments passed to \code{\link[boot]{boot}} used in this routine
for estimation of standard errors.}
}
\value{
A modified object of class \code{maxlogL}.
}
\description{
\code{bootstrap_maxlogL} computes standard errors of
\code{\link{maxlogL}} class objects by non-parametric bootstrap.
}
\details{
The computation performed by this function may be
invoked when Hessian from \code{\link{optim}} and
\code{\link[numDeriv]{hessian}} fail in  \code{\link{maxlogL}} or
in \code{\link{maxlogLreg}}.

However, this function can be run even if Hessian matrix calculation
does not fails. In this case, standard errors in the \code{\link{maxlogL}}
class object is replaced.
}
\examples{
library(EstimationTools)

#--------------------------------------------------------------------------------
# First example: Comparison between standard error computation via Hessian matrix
# and standard error computation via bootstrap

N <- rbinom(n = 100, size = 10, prob = 0.3)
phat1 <- maxlogL(x = N, dist = 'dbinom', fixed = list(size = 10),
                link = list(over = "prob", fun = "logit_link"))

## Standard error computation method and results
print(phat1$outputs$StdE_Method)   # Hessian
summary(phat1)

## 'bootstrap_maxlogL' implementation
phat2 <- phat1                   # Copy the first 'maxlogL' object
bootstrap_maxlogL(phat2, R = 100)

## Standard error computation method and results
print(phat2$outputs$StdE_Method)   # Bootstrap
summary(phat2)


#--------------------------------------------------------------------------------

}
\references{
\insertRef{Canty2017}{EstimationTools}
}
\seealso{
\code{\link{maxlogL}}, \code{\link{maxlogLreg}}, \code{\link[boot]{boot}}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
