% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortMethod.R
\name{preparePsPlot}
\alias{preparePsPlot}
\title{Prepare to plot the propensity score distribution}
\usage{
preparePsPlot(data, unfilteredData = NULL, scale = "preference")
}
\arguments{
\item{data}{A data frame with at least the two columns described below}

\item{unfilteredData}{To be used when computing preference scores on data from which subjects have
already been removed, e.g. through trimming and/or matching. This data frame
should have the same structure as \code{data}.}

\item{scale}{The scale of the graph. Two scales are supported: \code{scale = 'propensity'} or
\code{scale = 'preference'}. The preference score scale is defined by Walker et
al. (2013).}
}
\value{
A data frame describing the propensity score (or preference score) distribution at 100
equally-spaced points.
}
\description{
Prepare to plot the propensity (or preference) score distribution. It computes the distribution, so
the output does not contain person-level data.
}
\details{
The data frame should have a least the following two columns:
\itemize{
\item \strong{treatment} (integer): Column indicating whether the person is in the treated (1) or comparator
(0) group. - \strong{propensityScore} (numeric): Propensity score.
}
}
\examples{
# Simulate some data for this example:
treatment <- rep(0:1, each = 100)
propensityScore <- c(rnorm(100, mean = 0.4, sd = 0.25), rnorm(100, mean = 0.6, sd = 0.25))
data <- data.frame(treatment = treatment, propensityScore = propensityScore)
data <- data[data$propensityScore > 0 & data$propensityScore < 1, ]

preparedPlot <- preparePsPlot(data)

}
\references{
Walker AM, Patrick AR, Lauer MS, Hornbrook MC, Marin MG, Platt R, Roger VL, Stang P, and
Schneeweiss S. (2013) A tool for assessing the feasibility of comparative effectiveness research,
Comparative Effective Research, 3, 11-20
}
\seealso{
\link{plotPreparedPs}
}
