% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gray_scale.R
\name{gray_scale}
\alias{gray_scale}
\title{Function to get a grayscale image from a color image (Funcao para a obtencao
de uma imagem em escala de cinza a partir de uma imagem colorida)}
\usage{
gray_scale(im,method="r",plot=FALSE)
}
\arguments{
\item{im}{:This object must contain an image in EBImage format (Este
objeto deve conter uma imagem no formato do EBImage).}

\item{method}{: Indicates the method for obtaining the gray scale (Este
objeto indica o metodo para a obtencao da escala de cinza).:\cr "r" =
extrair a banda de vermelho\cr "g" = extrair a banda de verde\cr "b" =
extrair a banda de azul\cr "rg" = considera a media da banda de vermelho e
verde: (r+g)/2\cr "rb" = considera a media da banda de vermelho e azul:
(r+b)/2\cr "gb" = considera a media da banda de verde e azul: (g+b)/2\cr
"gbb" = considera a media das 3 bandas: (r+g+b)/3\cr}

\item{plot}{:This object must contain an image in EBImage format (Indica
se sera apresentada (TRUE) ou nao (FALSE) (default) a imagem segmentada).}
}
\value{
Returns an image with text over each object in the image (Retorna uma
  imagem com um texto sobreposto a cada objeto na imagem)
}
\description{
Function to get a grayscale image from a color image (Esta
  funcao permite a obtencao de uma imagem em escala de cinza a partir de uma
  imagem colorida).
}
\examples{
#Carregar imagem de exemplo
im=read_image(example_image(2))
##mostrar imagem
plot(im)


#Extraindo as camadas R, G e B
r=gray_scale(im,method = "r",plot=TRUE)
g=gray_scale(im,method = "g",plot=TRUE)
b=gray_scale(im,method = "b",plot=TRUE)
}
\seealso{
\code{\link{segmentation_logit}}
}
