% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_png.R
\name{create_png}
\alias{create_png}
\title{Create a png image with a transparent background
(Criar uma imagem png com o fundo transparente)}
\usage{
create_png(im,segmentation,file=NULL,crop=FALSE)
}
\arguments{
\item{im}{:This object must contain an image in EBImage format (Este
objeto deve conter uma imagem no formato do EBImage).}

\item{segmentation}{Binary matrix obtained of a segmentation(matrix binaria obtida por uma segmentacao).}

\item{file}{Name of the file that will be saved with the `.png` extension
(Nome do arquivo que sera salvo com a extensao `.png`).}

\item{crop}{Logical variable, if it is TRUE the image will be cut considering the segmentation matrix
(Variavel logica, se for TRUE a imagem sera cortada considerando a matriz segmentation).}
}
\value{
: returns an image of type `.png` (retorna uma imagem do tipo `.png`).
}
\description{
Create a png image with a transparent background
(Criar uma imagem png com o fundo transparente)
}
\examples{
\donttest{
end=example_image(2)
im=read_image(end,plot=TRUE)
m=gray_scale(im,method = "GLI",plot=TRUE)
plot_image(m,col=3)
seg=segmentation(m,treshold = 0.2,fillHull = TRUE,plot=TRUE)

info_image(im)

im2=create_png(im,seg)
info_image(im2)
#write_image(im2,files = "imagem.png")

im2=create_png(im,seg,crop=TRUE)
info_image(im2)
#write_image(im2,files = "imagem.png")
}
}
\seealso{
\code{\link{segmentation} , \link{crop_image} }
}
