% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExplodeLayoutBasic.R
\name{explode_coordinates}
\alias{explode_coordinates}
\title{Explode the old coordinates using cluster membership}
\usage{
explode_coordinates(nodelist, radius = 1)
}
\arguments{
\item{nodelist}{A nodelist is a dataframe including at least 4 columns: Label, X, Y, Cluster. Label is the node ID. They must be unique character strings. X and Y are the original coordinates. Cluster is the node clustering membership. They must be integers ranging from 1 to the number of clusters.}

\item{radius}{The radius of the used to explode the clusters, which defaults to 1.}
}
\value{
A nodelist with new node layout coordinates generated from the algorithm. This is a new dataframe with 4 colums: Label, newX, newY, Cluster.
}
\description{
Takes the nodelist of a network and return an updated nodelist with the exploded coordinates.
}
\examples{
exploded_coords=explode_coordinates(example_nodelist,radius=1.2)
}
