% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Gumbel}
\alias{Gumbel}
\alias{dGumbel}
\alias{eGumbel}
\alias{lGumbel}
\alias{pGumbel}
\alias{qGumbel}
\alias{rGumbel}
\title{The Gumbel Distribution.}
\usage{
dGumbel(x, location = 0, scale = 1, params = list(location = 0, scale =
  1))

pGumbel(q, location = 0, scale = 1, params = list(location = 0, scale =
  1))

qGumbel(p, location = 0, scale = 1, params = list(location = 0, scale =
  1))

rGumbel(n, location = 0, scale = 1, params = list(location = 0, scale =
  1))

eGumbel(X, w, method = "numerical.MLE")

lGumbel(X, w, location = 0, scale = 1, params = list(location = 0, scale =
  1), logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{location}{location parameter.}

\item{scale}{scale parameter.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lGumbel gives log likelihood.}

\item{...}{other parameters}
}
\value{
dGumbel gives the density; pGumbel gives the distribution function;
qGumbel gives the quantile function; rGumbel generates random variables;
eGumbel estimate the parameters
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Gumbel distribution
}
\details{
Gumbel Distribution

See \href{../doc/Distributions-Gumbel.html}{Distributions-Gumbel}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
location <- 1.5
scale <- 0.5
X <- rGumbel(n, location, scale)
(est.par <- eGumbel(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dGumbel(den.x,location=est.par$location,scale=est.par$scale)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qGumbel((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(0,5), ylim = c(0,5))
abline(0,1)

plot((1:n-0.5)/n, pGumbel(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(location=1, scale=2)
X <- rGumbel(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eGumbel(X,w) # estimated parameters of weighted sample
eGumbel(X) # estimated parameters of unweighted sample

# Extracting location or scale parameters
est.par[attributes(est.par)$par.type=="location"]
est.par[attributes(est.par)$par.type=="scale"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rGumbel,edist=eGumbel,n = 1000, rep.num = 1e3,
   params = list(location=1, scale=2))

# evaluate the precision of estimation by Hessian matrix
X <- rGumbel(1000, location, scale)
(est.par <- eGumbel(X))
H <- attributes(eGumbel(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lGumbel(X,param = est.par)
lGumbel(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

