% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VapPres.R
\name{RelHum}
\alias{RelHum}
\title{Relative Humidity (RH)}
\usage{
RelHum(e_a, e0T)
}
\arguments{
\item{e_a}{Optional. A numeric scalar that denotes the actual vapour pressure [kPa].}

\item{e0T}{A numeric scalar that denotes the saturation vapour pressure at a specific air temperature [kPa].}
}
\value{
The function returns the value of the relative humidity as a numeric scalar.
}
\description{
\code{RelHum} returns the value of relative humidity.
}
\details{
This is a function to calculate the relative humidity.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
RelHum(e_a = 0.7, e0T = 0.9)

}
\seealso{
\code{\link{SatVP}}.
}
