% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_post.R
\name{FCVARforecast}
\alias{FCVARforecast}
\title{Forecasts with the FCVAR Model}
\usage{
FCVARforecast(x, model, NumPeriods)
}
\arguments{
\item{x}{A matrix of variables to be included in the system.
The forecast will be calculated using these values as starting values.}

\item{model}{A list of estimation results, just as if estimated from \code{FCVARest}.
The parameters in \code{model} can also be set or adjusted by assigning new values.}

\item{NumPeriods}{The number of time periods in the simulation.}
}
\value{
A \code{NumPeriods} \eqn{\times p} matrix \code{xf} of forecasted values.
}
\description{
\code{FCVARforecast} calculates recursive forecasts with the FCVAR model.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
opt1 <- opt
opt1$R_Alpha <- matrix(c(0, 1, 0), nrow = 1, ncol = 3)
m1r4 <- FCVARestn(x, k = 2, r = 1, opt1)
xf <- FCVARforecast(x, m1r4, NumPeriods = 12)
}
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} for the specification of the \code{model}.
\code{FCVARforecast} calls \code{FracDiff} and \code{Lbk} to calculate the forecast.

Other FCVAR auxiliary functions: 
\code{\link{FCVARlikeGrid}()},
\code{\link{FCVARsimBS}()},
\code{\link{FCVARsim}()},
\code{\link{FracDiff}()},
\code{\link{plot.FCVAR_grid}()}
}
\concept{FCVAR auxiliary functions}
