% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFFTrees_function.R
\name{plot.FFTrees}
\alias{plot.FFTrees}
\title{Plot an \code{FFTrees} object}
\usage{
\method{plot}{FFTrees}(
  x = NULL,
  data = "train",
  what = "all",
  tree = 1,
  main = NULL,
  cue.labels = NULL,
  decision.labels = NULL,
  cue.cex = NULL,
  threshold.cex = NULL,
  decision.cex = 1,
  comp = TRUE,
  show.header = NULL,
  show.tree = NULL,
  show.confusion = NULL,
  show.levels = NULL,
  show.roc = NULL,
  show.icons = NULL,
  show.iconguide = NULL,
  hlines = TRUE,
  label.tree = NULL,
  label.performance = NULL,
  n.per.icon = NULL,
  level.type = "bar",
  which.tree = NULL,
  decision.names = NULL,
  stats = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{FFTrees} object created by the \code{\link{FFTrees}} function.}

\item{data}{The type of data in \code{x} to be plotted (as a string) or a test dataset (as a data frame).
\itemize{
  \item{A valid data string must be either \code{'train'} (for fitting performance) or \code{'test'} (for prediction performance).}
  \item{For a valid data frame, the specified tree is evaluated and plotted for this data (as 'test' data),
  but the global \code{FFTrees} object \code{x} remains unchanged unless it is re-assigned.}
 }
By default, \code{data = 'train'} (as \code{x} may not contain test data).}

\item{what}{What should be plotted (as a string)? Valid options are:
\describe{
  \item{'all'}{Plot the tree diagram with all corresponding guides and performance statistics, but excluding cue accuracies.}
  \item{'cues'}{Plot only the marginal accuracy of cues in ROC space.
  Note that cue accuracies are \emph{not} shown when calling \code{what = 'all'} and use the \code{\link{showcues}} function.}
  \item{'icontree'}{Plot tree diagram with icon arrays on exit nodes.
  Consider also setting \code{n.per.icon} and \code{show.iconguide}.}
  \item{'tree'}{Plot only the tree diagram.}
  \item{'roc'}{Plot only the performance of tree(s) (and comparison algorithms) in ROC space.}
}
Default: \code{what = 'all'}.}

\item{tree}{The tree to be plotted (as an integer, only valid when the corresponding tree argument is non-empty).
Default: \code{tree = 1}.
To plot the best training or best test tree with respect to the \code{goal} specified during FFT construction,
use \code{'best.train'} or \code{'best.test'}, respectively.}

\item{main}{The main plot label (as a character string).}

\item{cue.labels}{An optional string of labels for the cues / nodes (as character vector).}

\item{decision.labels}{A character vector of length 2 indicating the content-specific names for noise and signal predictions/exits.}

\item{cue.cex}{The size of the cue labels (as numeric).}

\item{threshold.cex}{The size of the threshold labels (as numeric).}

\item{decision.cex}{The size of the decision labels (as numeric).}

\item{comp}{Should the performance of competitive algorithms (e.g.; logistic regression, random forests, etc.)
be shown in the ROC plot (if available, as logical)?}

\item{show.header}{Show header with basic data properties (in top panel, as logical)?}

\item{show.tree}{Show nodes and exits of FFT (in middle panel, as logical)?}

\item{show.confusion}{Show 2x2 confusion matrix (in bottom panel, as logical)?}

\item{show.levels}{Show performance levels (in bottom panel, as logical)?}

\item{show.roc}{Show ROC curve (in bottom panel, as logical)?}

\item{show.icons}{Show exit cases as icon arrays (in middle panel, as logical)?}

\item{show.iconguide}{Show icon guide (in middle panel, as logical)?}

\item{hlines}{Show horizontal panel separation lines (as logical)?
Default: \code{hlines = TRUE}.}

\item{label.tree}{Label for the FFT (optional, as character string).}

\item{label.performance}{Labels for the performance section (optional, as character string).}

\item{n.per.icon}{Number of cases per icon (as numeric).}

\item{level.type}{How should bottom levels be drawn (as a string)? Can be \code{"bar"} (the default) or \code{"line"}.}

\item{which.tree}{Deprecated argument. Use \code{tree} instead.}

\item{decision.names}{Deprecated argument. Use \code{decision.labels} instead.}

\item{stats}{Deprecated argument. Should statistical information be plotted (as logical)?
Use \code{what = "all"} to include performance statistics
and \code{what = "tree"} to plot only a tree diagram.}

\item{...}{Graphical parameters (passed to text of panel titles,
to \code{\link{showcues}} when \code{what = 'cues'}, or
to \code{\link{title}} when \code{what = 'roc'}).}
}
\value{
An invisible \code{FFTrees} object \code{x}
and a plot visualizing and describing an FFT (as side effect).
}
\description{
\code{plot.FFTrees} visualizes an \code{FFTrees} object created by the \code{\link{FFTrees}} function.

\code{plot.FFTrees} is the main plotting function of the \strong{FFTrees} package and
called when evaluating the generic \code{\link{plot}} on an \code{FFTrees} object.

\code{plot.FFTrees} visualizes a selected FFT, key data characteristics, and various aspects of classification performance.

As \code{x} may not contain test data, \code{plot.FFTrees} by default plots the performance characteristics
for training data (i.e., fitting), rather than for test data (i.e., for prediction).
When test data is available, specifying \code{data = "test"} plots prediction performance.

Whenever the sensitivity weight (\code{sens.w}) is set to its default of \code{sens.w = 0.50},
a level shows \emph{balanced} accuracy (\code{bacc}). If, however, \code{sens.w} deviates from its default,
the level shows the tree's \emph{weighted} accuracy value (\code{wacc}) and the current \code{sens.w} value (below the level).

Many aspects of the plot (e.g., its panels) and the FFT's appearance (e.g., labels of its nodes and exits)
can be customized by setting corresponding arguments.
}
\examples{
# Create FFTs (for heartdisease data):
heart.fft <- FFTrees(formula = diagnosis ~ .,
                     data = heart.train
                     )

# Visualize the default FFT (Tree #1, what = 'all'):
plot(heart.fft, main = "Heart disease",
     decision.labels = c("Absent", "Present"))

# Visualize cue accuracies (in ROC space):
plot(heart.fft, what = "cues",  main = "Cue accuracies for heart disease data")

# Visualize tree diagram with icon arrays on exit nodes:
plot(heart.fft, what = "icontree", n.per.icon = 2,
     main = "Diagnosing heart disease")

# Visualize performance comparison in ROC space:
plot(heart.fft, what = "roc", main = "Performance comparison for heart disease data")

# Visualize predictions of FFT #2 (for new test data) with custom options:
plot(heart.fft, tree = 2, data = heart.test,
     main = "Predicting heart disease",
     cue.labels = c("1. thal?", "2. cp?", "3. ca?", "4. exang"),
     decision.labels = c("ok", "sick"), n.per.icon = 2,
     show.header = TRUE, show.confusion = FALSE, show.levels = FALSE, show.roc = FALSE,
     hlines = FALSE, font = 3, col = "steelblue")

# For more details, see
vignette("FFTrees_plot", package = "FFTrees")

}
\seealso{
\code{\link{showcues}} for plotting cue accuracies;
\code{\link{print.FFTrees}} for printing FFTs;
\code{\link{summary.FFTrees}} for summarizing FFTs;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other plot functions: 
\code{\link{showcues}()}
}
\concept{plot functions}
