% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFTreesdata_doc.R
\docType{data}
\name{heartdisease}
\alias{heartdisease}
\title{Heart disease data}
\format{
A data frame containing 303 rows and 14 columns, with the following variables:

\describe{
  \item{diagnosis}{True value of binary criterion: TRUE = Heart disease, FALSE = No Heart disease}
  \item{age}{Age (in years)}
  \item{sex}{Sex, 1 = male, 0 = female}
  \item{cp}{Chest pain type: ta = typical angina, aa = atypical angina, np = non-anginal pain, a = asymptomatic}
  \item{trestbps}{Resting blood pressure (in mm Hg on admission to the hospital)}
  \item{chol}{Serum cholestoral in mg/dl}
  \item{fbs}{Fasting blood sugar > 120 mg/dl: 1 = true, 0 = false }
  \item{restecg}{Resting electrocardiographic results. "normal" = normal, "abnormal" = having ST-T wave abnormality (T wave inversions and/or ST elevation or depression of > 0.05 mV), "hypertrophy" = showing probable or definite left ventricular hypertrophy by Estes' criteria.}
  \item{thalach}{Maximum heart rate achieved}
  \item{exang}{Exercise induced angina: 1 = yes, 0 = no}
  \item{oldpeak}{ST depression induced by exercise relative to rest }
  \item{slope}{The slope of the peak exercise ST segment. }
  \item{ca}{Number of major vessels (0-3) colored by flourosopy }
  \item{thal}{"normal" = normal, "fd" = fixed defect, "rd" = reversible defect}


}
}
\source{
\url{https://archive.ics.uci.edu/ml/datasets/Heart+Disease}
}
\usage{
heartdisease
}
\description{
A dataset predicting the \code{diagnosis} of 303 patients tested for heart disease.
}
\seealso{
\code{\link{heart.cost}} dataset for cost information.

Other datasets: 
\code{\link{blood}},
\code{\link{breastcancer}},
\code{\link{car}},
\code{\link{contraceptive}},
\code{\link{creditapproval}},
\code{\link{fertility}},
\code{\link{forestfires}},
\code{\link{heart.cost}},
\code{\link{heart.test}},
\code{\link{heart.train}},
\code{\link{iris.v}},
\code{\link{mushrooms}},
\code{\link{sonar}},
\code{\link{titanic}},
\code{\link{voting}},
\code{\link{wine}}
}
\concept{datasets}
\keyword{datasets}
