% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_gfft.R
\name{reorder_nodes}
\alias{reorder_nodes}
\title{Reorder nodes in an FFT definition}
\usage{
reorder_nodes(fft, order = NA, quiet = FALSE)
}
\arguments{
\item{fft}{One FFT definition
(as a data frame in tidy format, with one row per node).}

\item{order}{The desired node order (as an integer vector).
The values of \code{order} must be a permutation of \code{1:nrow(fft)}.
Default: \code{order = NA}.}

\item{quiet}{Hide feedback messages (as logical)?
Default: \code{quiet = FALSE}.}
}
\value{
One FFT definition
(as a data frame in tidy format, with one row per node).
}
\description{
\code{reorder_nodes} allows reordering
the \code{nodes} in an existing FFT definition
(in the tidy data frame format).

\code{reorder_nodes} allows to directly set and change the node
order in an FFT definition by specifying \code{nodes}.

When a former non-final node becomes a final node,
the exit type of the former final node
is set to the signal value (i.e., \code{exit_types[2]}).
}
\seealso{
\code{\link{add_nodes}} for adding nodes to an FFT definition;
\code{\link{edit_nodes}} for editing nodes in an FFT definition;
\code{\link{drop_nodes}} for deleting nodes from an FFT definition;
\code{\link{flip_exits}} for reversing exits in an FFT definition;
\code{\link{select_nodes}} for selecting nodes in an FFT definition;
\code{\link{get_fft_df}} for getting the FFT definitions of an \code{FFTrees} object;
\code{\link{read_fft_df}} for reading one FFT definition from tree definitions;
\code{\link{add_fft_df}} for adding FFTs to tree definitions;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other tree definition and manipulation functions: 
\code{\link{add_fft_df}()},
\code{\link{add_nodes}()},
\code{\link{drop_nodes}()},
\code{\link{edit_nodes}()},
\code{\link{flip_exits}()},
\code{\link{get_fft_df}()},
\code{\link{read_fft_df}()},
\code{\link{select_nodes}()},
\code{\link{write_fft_df}()}
}
\concept{tree definition and manipulation functions}
