% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alkPlot.R
\name{ageKeyPlot}
\alias{ageKeyPlot}
\alias{alkPlot}
\title{Plots to visualize age-length keys.}
\usage{
ageKeyPlot(key, type = c("barplot", "area", "lines", "splines", "bubble"),
  xlab = "Length", ylab = ifelse(type != "bubble", "Proportion", "Age"),
  xlim = NULL, ylim = NULL, showLegend = FALSE, lbl.cex = 1.25,
  leg.cex = 1, lwd = 2, span = 0.25, pal = paletteChoices(),
  grid = TRUE, col = "gray80", buf = 0.45, add = FALSE, ...)

alkPlot(key, type = c("barplot", "area", "lines", "splines", "bubble"),
  xlab = "Length", ylab = ifelse(type != "bubble", "Proportion", "Age"),
  xlim = NULL, ylim = NULL, showLegend = FALSE, lbl.cex = 1.25,
  leg.cex = 1, lwd = 2, span = 0.25, pal = paletteChoices(),
  grid = TRUE, col = "gray80", buf = 0.45, add = FALSE, ...)
}
\arguments{
\item{key}{A numeric matrix that contains the age-length key.}

\item{type}{A string that indicates the type of plot to construct.  See details.}

\item{xlab, ylab}{A string that contains the label for the x- or y-axis.}

\item{xlim, ylim}{A numeric of length 2 that provide the limits for the x-axis or y-axis.}

\item{showLegend}{A logical that indicates whether a legend should be displayed (not implemented for \code{type="bubble"}).  See examples.}

\item{lbl.cex}{A numeric character expansion value for labels inside the bars when \code{type="barplot"} or on the lines when \code{type="lines"} or \code{type="splines"}.  Only used if \code{showLegend=FALSE}.}

\item{leg.cex}{A numeric character expansion value for labels on the legend when \code{showLegend=TRUE}.}

\item{lwd}{A numeric that indicates the line width when \code{type="lines"} or \code{type="splines"}.}

\item{span}{A numeric that indicates the span value to use in \code{loess} when \code{type="splines"}.}

\item{pal}{A string that indicates the palette to generate colors for the bars, areas, lines, or spline lines.  The name of a palette must be one of \dQuote{rich}, \dQuote{cm}, \dQuote{default}, \dQuote{grey}, \dQuote{gray}, \dQuote{heat}, \dQuote{jet}, \dQuote{rainbow}, \dQuote{topo}, or \dQuote{terrain}.  See \code{\link{chooseColors}}.}

\item{grid}{A logical that indicates whether a grid should be placed under the bubbles when \code{type="bubble"} or a character or appropriate vector that identifies a color for the grid.  See examples.}

\item{col}{A string that indicates the color of the bubbles when \code{type="bubble"}.}

\item{buf}{A single numeric that indicates the relative width of the bubbles when \code{type="bubble"}.  A value of 0.5 means that two full-width bubbles would touch each other either in the x- or y-direction (i.e., this would represent half of the minimum of the physical distance between values one-unit apart on the x- and y-axes).  Set this to a value less than 0.5 so that the bubbles will not touch (the default is 0.45).}

\item{add}{A logical that indicates whether the data should be added to an already existing plot.  May be useful for visually comparing age-length keys.  Only implemented when \code{type="bubble"}.}

\item{\dots}{Additional arguments to pass to \code{plot} or \code{barplot}.}
}
\value{
None, but a plot is constructed.
}
\description{
Various plots to visualize the proportion of fish of certain ages within length intervals in an age-length key.
}
\details{
A variety of plots can be used to visualize the proportion of fish of certain ages within length intervals of an age-length key.  The types of plots are described below and illustrated in the examples.
\itemize{
  \item A \dQuote{stacked} bar chart where vertical bars over length intervals sum to 1 but are segmented by the proportion of each age in that length interval is constructed with \code{type="barplot"}.  The ages will be labeled in the bar segments unless \code{showLegend=TRUE} is used.
  \item A \dQuote{stacked} area chart similar to the bar chart described above is constructed with \code{type="area"}.
  \item A plot with (differently colored) lines that connect the proportions of ages within each length interval is constructed with \code{type="lines"}.
  \item A plot with (differently colored) lines, as estimated by loess splines, that connect the proportions of ages within each length interval is constructed with \code{type="splines"}.
  \item A \dQuote{bubble} plot where circles whose size is proportional to the proportion of fish of each age in each length interval is constructed with \code{type="bubble"}.  The color of the bubbles can be controlled with \code{col=} and an underlying grid for ease of seeing the age and length interval for each bubble can be controlled with \code{grid=}.  Bubbles from a second age-length key can be overlaid on an already constructed bubble plot by using \code{add=TRUE} in a second call to \code{alkPlot}.
}
Note that all plots are \dQuote{vertically conditional} -- i.e., each represents the proportional ages WITHIN each length interval.
}
\section{IFAR Chapter}{
 5-Age-Length Key.
}
\examples{
## Make an example age-length key -- same as in ageKey()
data(WR79)
WR.age <- subset(WR79, !is.na(age))      # isolate the age sample
WR.age$LCat <- lencat(WR.age$len,w=5)    # add length intervals (width=5)
raw <- xtabs(~LCat+age,data=WR.age)      # create age-length key
( WR.key <- prop.table(raw, margin=1) )

## Various visualizations of the age-length key
alkPlot(WR.key,"barplot")
alkPlot(WR.key,"barplot",pal="gray")
alkPlot(WR.key,"barplot",showLegend=TRUE)
alkPlot(WR.key,"area")
alkPlot(WR.key,"area",showLegend=TRUE)
alkPlot(WR.key,"area",pal="gray")
alkPlot(WR.key,"lines")
alkPlot(WR.key,"lines",pal="gray")
alkPlot(WR.key,"lines",showLegend=TRUE)
alkPlot(WR.key,"splines")
alkPlot(WR.key,"splines",span=0.2)
alkPlot(WR.key,"splines",pal="gray",showLegend=TRUE)
alkPlot(WR.key,"bubble")
alkPlot(WR.key,"bubble",grid=FALSE)
alkPlot(WR.key,"bubble",grid="blue")
alkPlot(WR.key,"bubble",grid=rgb(0,0,0,0.2),col=rgb(0,0,0,0.5))

}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\references{
Ogle, D.H.  2016.  \href{http://derekogle.com/IFAR}{Introductory Fisheries Analyses with R}.  Chapman & Hall/CRC, Boca Raton, FL.
}
\seealso{
See \code{\link{alkIndivAge}} for using an age-length key to assign ages to individual fish.
}
\keyword{plot}

