% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDpartner.R
\name{IDpartner}
\alias{IDpartner}
\title{Retrieves ID of partner of ego or allocate partner to ego}
\usage{
IDpartner(idego, dLH)
}
\arguments{
\item{idego}{vector of ID of egos. If idego is missing, then the function
allocates partners (from opposite sex) to egos. The allocation is random.}

\item{dLH}{Name of database. If missing, dataLH_F is used.}
}
\value{
IDs of partners. If the argument idego is missing, then a data frame
similar to 'dLH' is returned with IDs of partners completed.
}
\description{
Retrieves ID of partners of vector of egos or randomly allocates partners to
egos
}
\examples{

data(dataLH_F,package = "Families")
IDpartner(idego=1)
# Allocate partner to egos with ID 4,9,30.
IDpartner(idego=dataLH_F$ID[c(4,9,30)])  

}
\author{
Frans Willekens
}
