% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{farmTestTwo}
\alias{farmTestTwo}
\title{Two sample FarmTest with unknown factors}
\usage{
farmTestTwo(X, Y, h0, KX = -1L, KY = -1L, alpha = 0.05,
  alternative = "two.sided")
}
\arguments{
\item{X}{An \eqn{nX} by \eqn{p} data matrix with each row being a sample.}

\item{Y}{An \eqn{nY} by \eqn{p} data matrix with each row being a sample. The number of columns of \code{X} and \code{Y} must be the same.}

\item{h0}{A \eqn{p}-vector of true difference in means.}

\item{KX}{An \strong{optional} positive number of factors to be estimated for \code{X}. \code{KX} cannot exceed the number of columns of \code{X}. If \code{KX} is not specified or specified to be negative, it will be estimated internally.}

\item{KY}{An \strong{optional} positive number of factors to be estimated for \code{Y}. \code{KY} cannot exceed the number of columns of \code{Y}. If \code{KY} is not specified or specified to be negative, it will be estimated internally.}

\item{alpha}{An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.}

\item{alternative}{An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".}
}
\description{
Internal function implemented in C++ for two sample FarmTest with unknown factors. This case is incorporated into \code{farm.test}.
}
\seealso{
\code{\link{farm.test}}
}
