% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmTestTwoBoot}
\alias{rmTestTwoBoot}
\title{Two sample robust multiple testing with multiplier bootstrap}
\usage{
rmTestTwoBoot(X, Y, h0, alpha = 0.05, alternative = "two.sided",
  B = 500L)
}
\arguments{
\item{X}{An \eqn{nX} by \eqn{p} data matrix with each row being a sample.}

\item{Y}{An \eqn{nY} by \eqn{p} data matrix with each row being a sample. The number of columns of \code{X} and \code{Y} must be the same.}

\item{h0}{A \eqn{p}-vector of true difference in means.}

\item{alpha}{An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.}

\item{alternative}{An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".}

\item{B}{An \strong{optional} positive integer specifying the size of bootstrap sample. The dafault value is 500.}
}
\description{
Internal function implemented in C++ for two sample robust multiple testing without factor-adjustment, where p-values are obtained via multiplier bootstrap. 
This case is incorporated into \code{farm.test}.
}
\seealso{
\code{\link{farm.test}}
}
