% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{read_rp_xlsx}
\alias{read_rp_xlsx}
\title{Read retention times (RT) measured on a reverse phase (RP) column}
\source{
Measured by functional genomics lab at the University of Regensburg.
}
\usage{
read_rp_xlsx()
}
\value{
A dataframe of 442 metabolites with columns \code{RT}, \code{SMILES} and \code{NAME}.
}
\description{
Read retention time data from a reverse phase liquid chromatography measured with a temperature of 35 degree and a flowrate of 0.3ml/min. The data also exists as dataframe in the package. To use it directly in R just enter \code{RP}.
}
\examples{
\donttest{
x <- read_rp_xlsx()
all.equal(x, RP)
}
}
\seealso{
RP
}
\keyword{dataset}
