% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/UTILITY_FUNCTIONS.R
\name{curlDownload}
\alias{curlDownload}
\title{Use RCurl to download a file.}
\usage{
curlDownload(url, destdir = getwd(), timestamping = T, nc = F,
  verbose = F, progress = F)
}
\arguments{
\item{url}{The location of a file.}

\item{destdir}{Where the file should be downloaded to.}

\item{timestamping}{Should only newer files be downloaded?}

\item{nc}{Should files of the same type not be clobbered?}

\item{verbose}{Should cURL output be shown?}

\item{progress}{Should a progress bar be shown with cURL output?}
}
\value{
A logical vector of the same length as x.
}
\description{
This function makes it easy to implement timestamping and no-clobber of files.
Unlike \link{wgetDownload}, it doesn't require an external command-line tool to
be installed.
}
\details{
If both \code{timestamping} and \code{nc} are TRUE, nc behavior trumps timestamping.
}

