% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedirt_2PL_median_data.R
\name{fedirt_2PL_median_data}
\alias{fedirt_2PL_median_data}
\title{Federated 2PL model}
\usage{
fedirt_2PL_median_data(inputdata)
}
\arguments{
\item{inputdata}{A List of all responding matrix.}
}
\value{
A list with the estimated global discrimination a, global difficulty b, person's abilities ability, sites' abilities site, and log-likelihood value loglik.
}
\description{
This function is only used to test the accuracy and processing time of this algorithm. It inputs a list of responding matrices and return the federated 2PL parameters.
Note: This function can only calculate one combined dataset. To use federated 2PL in distributed datasets, please use fedirt_2PL().
}
\details{
Input is a List of responding matrices from each school, every responding matrix is one site's data. It uses Federated median instead of FedAvg and FedSGD. The results are not same as traditional 2PL method, but is robust if there are outliers.
}
\examples{
\donttest{
inputdata = list(as.matrix(example_data_2PL))
fedresult = fedirt_2PL_median_data(inputdata)

inputdata = list(as.matrix(example_data_2PL_1), as.matrix(example_data_2PL_2))
fedresult = fedirt_2PL_median_data(inputdata)
}
}
