% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias.R
\name{bias}
\alias{bias}
\title{Bias}
\usage{
bias(observados, estimados)
}
\arguments{
\item{observados}{vector of values observed.}

\item{estimados}{vector of values estimated.}
}
\description{
In statistics, the bias (or bias function) of an estimator is the difference between this estimator's expected value and the true value of the parameter being estimated. An estimator or decision rule with zero bias is called unbiased. Otherwise the estimator is said to be biased.
}
\details{
bias = (sum(estimados-observados))/length(observados)
}
\references{
see \url{https://en.wikipedia.org/wiki/Bias_of_an_estimator} for more details.
}

