% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_S3_methods.R
\name{plot.FielDHub}
\alias{plot.FielDHub}
\title{Plot a \code{FielDHub} object}
\usage{
\method{plot}{FielDHub}(x, ...)
}
\arguments{
\item{x}{a object inheriting from class \code{FielDHub}}

\item{...}{further arguments passed to utility function \code{plot_layout()}.
\itemize{
  \item \code{layout} a integer. Options available depend on the 
  type of design and its characteristics
  \item \code{l} a integer to specify the location to plot.
  \item \code{planter} it can be \code{serpentine} or \code{cartesian}.
  \item \code{stacked} it can be \code{vertical} or \code{horizontal} stacked layout.
}}
}
\value{
\itemize{
  \item a plot object inheriting from class \code{fieldLayout}
  \item \code{field_book} a data frame with the fieldbook that includes the coordinates ROW and COLUMN.
}
}
\description{
Draw a field layout plot for a \code{FielDHub} object.
}
\examples{
\dontrun{
# Example 1: Plot a RCBD design with 24 treatments and 3 reps.
s <- RCBD(t = 24, reps = 3, plotNumber = 101, seed = 12)
plot(s)
}

}
\author{
Didier Murillo [aut]
}
