% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fl_LoadFjord.R
\name{fl_LoadFjord}
\alias{fl_LoadFjord}
\title{Load fjord PAR data from a NetCDF file downloaded by \code{FjordLight}.}
\usage{
fl_LoadFjord(fjord, dirdata = NULL, TS = FALSE, verbose = FALSE)
}
\arguments{
\item{fjord}{Expects a character vector for one of the 8 available fjords.
See \code{\link{fl_ListFjords}} for the list of possible choices.}

\item{dirdata}{The directory where the user would like to load the data from.}

\item{TS}{The default, \code{FALSE}, will prevent this function from loading the
monthly bottom PAR values. Instead it will load all global, annual, and monthly
climatology data. Set \code{TS = TRUE} to load all data, but note that these
may be extremely large.}

\item{verbose}{\code{TRUE} or \code{FALSE} (default) to provide a more verbose output
of the data loading process.}
}
\value{
Data are loaded in as a complex list format. Containing most of the data fields
described in the documentation for \code{\link{fl_DownloadFjord}}.
}
\description{
This functions will load into the R environment the data within one NetCDF
file that has been downloaded via \code{\link{fl_DownloadFjord}}.
}
\examples{
# Choose + download fjord
fjord_code <- "test"
fl_DownloadFjord(fjord_code, dirdata = tempdir())

# Load global, annual, and monthly climatologies
fjorddata <- fl_LoadFjord(fjord_code, dirdata = tempdir())

# Load ALL data
fjorddata_full <- fl_LoadFjord(fjord_code, dirdata = tempdir(), TS = TRUE)  # NB: TS = TRUE

}
\author{
Bernard Gentili & Robert Schlegel
}
