// Generated by rstantools.  Do not edit by hand.

/*
    FlexReg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FlexReg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FlexReg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_VIB0_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_VIB0");
    reader.add_event(97, 95, "end", "model_VIB0");
    return reader;
}
#include <stan_meta_header.hpp>
class model_VIB0
  : public stan::model::model_base_crtp<model_VIB0> {
private:
        int N;
        vector_d y;
        int K;
        int K0;
        matrix_d X;
        matrix_d X0;
        int link_code_mu;
        int link_prior_beta;
        int link_prior_omega0;
        double hyperprior_beta;
        double hyperprior_omega0;
        int prior_code_phi;
        double hyper_phi;
public:
    model_VIB0(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_VIB0(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_VIB0_namespace::model_VIB0";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 3;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "K0", "int", context__.to_vec());
            K0 = int(0);
            vals_i__ = context__.vals_i("K0");
            pos__ = 0;
            K0 = vals_i__[pos__++];
            check_greater_or_equal(function__, "K0", K0, 1);
            current_statement_begin__ = 6;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,K));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, K);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = K;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("X0", "N", N);
            validate_non_negative_index("X0", "K0", K0);
            context__.validate_dims("data initialization", "X0", "matrix_d", context__.to_vec(N,K0));
            X0 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, K0);
            vals_r__ = context__.vals_r("X0");
            pos__ = 0;
            size_t X0_j_2_max__ = K0;
            size_t X0_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X0_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X0_j_1_max__; ++j_1__) {
                    X0(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "link_code_mu", "int", context__.to_vec());
            link_code_mu = int(0);
            vals_i__ = context__.vals_i("link_code_mu");
            pos__ = 0;
            link_code_mu = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_code_mu", link_code_mu, 1);
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "link_prior_beta", "int", context__.to_vec());
            link_prior_beta = int(0);
            vals_i__ = context__.vals_i("link_prior_beta");
            pos__ = 0;
            link_prior_beta = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_prior_beta", link_prior_beta, 1);
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "link_prior_omega0", "int", context__.to_vec());
            link_prior_omega0 = int(0);
            vals_i__ = context__.vals_i("link_prior_omega0");
            pos__ = 0;
            link_prior_omega0 = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_prior_omega0", link_prior_omega0, 1);
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "hyperprior_beta", "double", context__.to_vec());
            hyperprior_beta = double(0);
            vals_r__ = context__.vals_r("hyperprior_beta");
            pos__ = 0;
            hyperprior_beta = vals_r__[pos__++];
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "hyperprior_omega0", "double", context__.to_vec());
            hyperprior_omega0 = double(0);
            vals_r__ = context__.vals_r("hyperprior_omega0");
            pos__ = 0;
            hyperprior_omega0 = vals_r__[pos__++];
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "prior_code_phi", "int", context__.to_vec());
            prior_code_phi = int(0);
            vals_i__ = context__.vals_i("prior_code_phi");
            pos__ = 0;
            prior_code_phi = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_code_phi", prior_code_phi, 1);
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "hyper_phi", "double", context__.to_vec());
            hyper_phi = double(0);
            vals_r__ = context__.vals_r("hyper_phi");
            pos__ = 0;
            hyper_phi = vals_r__[pos__++];
            check_greater_or_equal(function__, "hyper_phi", hyper_phi, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 18;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 19;
            validate_non_negative_index("omega0", "K0", K0);
            num_params_r__ += K0;
            current_statement_begin__ = 20;
            num_params_r__ += 1;
            current_statement_begin__ = 21;
            num_params_r__ += 1;
            current_statement_begin__ = 22;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_VIB0() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 18;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(K);
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 19;
        if (!(context__.contains_r("omega0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable omega0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("omega0");
        pos__ = 0U;
        validate_non_negative_index("omega0", "K0", K0);
        context__.validate_dims("parameter initialization", "omega0", "vector_d", context__.to_vec(K0));
        Eigen::Matrix<double, Eigen::Dynamic, 1> omega0(K0);
        size_t omega0_j_1_max__ = K0;
        for (size_t j_1__ = 0; j_1__ < omega0_j_1_max__; ++j_1__) {
            omega0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(omega0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable omega0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 20;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 21;
        if (!(context__.contains_r("k")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable k missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "k", "double", context__.to_vec());
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, k);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable k: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 22;
        if (!(context__.contains_r("p")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "p", "double", context__.to_vec());
        double p(0);
        p = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, p);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 18;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(K, lp__);
            else
                beta = in__.vector_constrain(K);
            current_statement_begin__ = 19;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> omega0;
            (void) omega0;  // dummy to suppress unused var warning
            if (jacobian__)
                omega0 = in__.vector_constrain(K0, lp__);
            else
                omega0 = in__.vector_constrain(K0);
            current_statement_begin__ = 20;
            local_scalar_t__ phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.scalar_lb_constrain(0, lp__);
            else
                phi = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 21;
            local_scalar_t__ k;
            (void) k;  // dummy to suppress unused var warning
            if (jacobian__)
                k = in__.scalar_lub_constrain(0, 1, lp__);
            else
                k = in__.scalar_lub_constrain(0, 1);
            current_statement_begin__ = 22;
            local_scalar_t__ p;
            (void) p;  // dummy to suppress unused var warning
            if (jacobian__)
                p = in__.scalar_lub_constrain(0, 1, lp__);
            else
                p = in__.scalar_lub_constrain(0, 1);
            // transformed parameters
            current_statement_begin__ = 27;
            validate_non_negative_index("mu", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(N);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 28;
            validate_non_negative_index("b1", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b1(N);
            stan::math::initialize(b1, DUMMY_VAR__);
            stan::math::fill(b1, DUMMY_VAR__);
            current_statement_begin__ = 29;
            validate_non_negative_index("b2", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b2(N);
            stan::math::initialize(b2, DUMMY_VAR__);
            stan::math::fill(b2, DUMMY_VAR__);
            current_statement_begin__ = 30;
            validate_non_negative_index("a1", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a1(N);
            stan::math::initialize(a1, DUMMY_VAR__);
            stan::math::fill(a1, DUMMY_VAR__);
            current_statement_begin__ = 31;
            validate_non_negative_index("a2", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a2(N);
            stan::math::initialize(a2, DUMMY_VAR__);
            stan::math::fill(a2, DUMMY_VAR__);
            current_statement_begin__ = 32;
            validate_non_negative_index("q0", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> q0(N);
            stan::math::initialize(q0, DUMMY_VAR__);
            stan::math::fill(q0, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 34;
            stan::math::assign(q0, inv_logit(multiply(X0, omega0)));
            current_statement_begin__ = 36;
            if (as_bool(logical_eq(link_code_mu, 1))) {
                current_statement_begin__ = 37;
                stan::math::assign(mu, inv_logit(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 2))) {
                current_statement_begin__ = 39;
                stan::math::assign(mu, Phi(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 3))) {
                current_statement_begin__ = 41;
                stan::math::assign(mu, inv_cloglog(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 4))) {
                current_statement_begin__ = 43;
                stan::math::assign(mu, stan::math::exp(minus(stan::math::exp(multiply(X, beta)))));
            }
            current_statement_begin__ = 45;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 47;
                stan::model::assign(b2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (((1 - get_base1(mu, i, "mu", 1)) * phi) * k), 
                            "assigning variable b2");
                current_statement_begin__ = 48;
                stan::model::assign(a2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((get_base1(mu, i, "mu", 1) * phi) * k), 
                            "assigning variable a2");
                current_statement_begin__ = 50;
                stan::model::assign(b1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((1 - get_base1(mu, i, "mu", 1)) * phi), 
                            "assigning variable b1");
                current_statement_begin__ = 51;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mu, i, "mu", 1) * phi), 
                            "assigning variable a1");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 27;
            size_t mu_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, 1);
            current_statement_begin__ = 28;
            size_t b1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "b1", b1, 0);
            current_statement_begin__ = 29;
            size_t b2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "b2", b2, 0);
            current_statement_begin__ = 30;
            size_t a1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(a1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable a1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "a1", a1, 0);
            current_statement_begin__ = 31;
            size_t a2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(a2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable a2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "a2", a2, 0);
            current_statement_begin__ = 32;
            size_t q0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < q0_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(q0(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: q0" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable q0: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "q0", q0, 0);
            check_less_or_equal(function__, "q0", q0, 1);
            // model body
            current_statement_begin__ = 57;
            if (as_bool(logical_eq(prior_code_phi, 1))) {
                current_statement_begin__ = 58;
                lp_accum__.add(gamma_log<propto__>(phi, hyper_phi, hyper_phi));
            } else if (as_bool(logical_eq(prior_code_phi, 2))) {
                current_statement_begin__ = 60;
                lp_accum__.add(uniform_log<propto__>(phi, 0.0, hyper_phi));
            }
            current_statement_begin__ = 62;
            for (int l = 1; l <= K; ++l) {
                current_statement_begin__ = 63;
                if (as_bool(logical_eq(link_prior_beta, 1))) {
                    current_statement_begin__ = 64;
                    lp_accum__.add(normal_log<propto__>(get_base1(beta, l, "beta", 1), 0, hyperprior_beta));
                } else if (as_bool(logical_eq(link_prior_beta, 2))) {
                    current_statement_begin__ = 66;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(beta, l, "beta", 1), 0, hyperprior_beta));
                }
            }
            current_statement_begin__ = 69;
            for (int l = 1; l <= K0; ++l) {
                current_statement_begin__ = 70;
                if (as_bool(logical_eq(link_prior_omega0, 1))) {
                    current_statement_begin__ = 71;
                    lp_accum__.add(normal_log<propto__>(get_base1(omega0, l, "omega0", 1), 0, hyperprior_omega0));
                } else if (as_bool(logical_eq(link_prior_omega0, 2))) {
                    current_statement_begin__ = 73;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(omega0, l, "omega0", 1), 0, hyperprior_omega0));
                }
            }
            current_statement_begin__ = 77;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 78;
                if (as_bool(logical_eq(get_base1(y, i, "y", 1), 0))) {
                    current_statement_begin__ = 79;
                    lp_accum__.add(stan::math::log(get_base1(q0, i, "q0", 1)));
                } else {
                    current_statement_begin__ = 81;
                    lp_accum__.add((log1m(get_base1(q0, i, "q0", 1)) + log_mix(p, beta_log(get_base1(y, i, "y", 1), get_base1(a2, i, "a2", 1), get_base1(b2, i, "b2", 1)), beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1)))));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("omega0");
        names__.push_back("phi");
        names__.push_back("k");
        names__.push_back("p");
        names__.push_back("mu");
        names__.push_back("b1");
        names__.push_back("b2");
        names__.push_back("a1");
        names__.push_back("a2");
        names__.push_back("q0");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_VIB0_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(K);
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> omega0 = in__.vector_constrain(K0);
        size_t omega0_j_1_max__ = K0;
        for (size_t j_1__ = 0; j_1__ < omega0_j_1_max__; ++j_1__) {
            vars__.push_back(omega0(j_1__));
        }
        double phi = in__.scalar_lb_constrain(0);
        vars__.push_back(phi);
        double k = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(k);
        double p = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(p);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 27;
            validate_non_negative_index("mu", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(N);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 28;
            validate_non_negative_index("b1", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b1(N);
            stan::math::initialize(b1, DUMMY_VAR__);
            stan::math::fill(b1, DUMMY_VAR__);
            current_statement_begin__ = 29;
            validate_non_negative_index("b2", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b2(N);
            stan::math::initialize(b2, DUMMY_VAR__);
            stan::math::fill(b2, DUMMY_VAR__);
            current_statement_begin__ = 30;
            validate_non_negative_index("a1", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> a1(N);
            stan::math::initialize(a1, DUMMY_VAR__);
            stan::math::fill(a1, DUMMY_VAR__);
            current_statement_begin__ = 31;
            validate_non_negative_index("a2", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> a2(N);
            stan::math::initialize(a2, DUMMY_VAR__);
            stan::math::fill(a2, DUMMY_VAR__);
            current_statement_begin__ = 32;
            validate_non_negative_index("q0", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> q0(N);
            stan::math::initialize(q0, DUMMY_VAR__);
            stan::math::fill(q0, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 34;
            stan::math::assign(q0, inv_logit(multiply(X0, omega0)));
            current_statement_begin__ = 36;
            if (as_bool(logical_eq(link_code_mu, 1))) {
                current_statement_begin__ = 37;
                stan::math::assign(mu, inv_logit(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 2))) {
                current_statement_begin__ = 39;
                stan::math::assign(mu, Phi(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 3))) {
                current_statement_begin__ = 41;
                stan::math::assign(mu, inv_cloglog(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 4))) {
                current_statement_begin__ = 43;
                stan::math::assign(mu, stan::math::exp(minus(stan::math::exp(multiply(X, beta)))));
            }
            current_statement_begin__ = 45;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 47;
                stan::model::assign(b2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (((1 - get_base1(mu, i, "mu", 1)) * phi) * k), 
                            "assigning variable b2");
                current_statement_begin__ = 48;
                stan::model::assign(a2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((get_base1(mu, i, "mu", 1) * phi) * k), 
                            "assigning variable a2");
                current_statement_begin__ = 50;
                stan::model::assign(b1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((1 - get_base1(mu, i, "mu", 1)) * phi), 
                            "assigning variable b1");
                current_statement_begin__ = 51;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mu, i, "mu", 1) * phi), 
                            "assigning variable a1");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 27;
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, 1);
            current_statement_begin__ = 28;
            check_greater_or_equal(function__, "b1", b1, 0);
            current_statement_begin__ = 29;
            check_greater_or_equal(function__, "b2", b2, 0);
            current_statement_begin__ = 30;
            check_greater_or_equal(function__, "a1", a1, 0);
            current_statement_begin__ = 31;
            check_greater_or_equal(function__, "a2", a2, 0);
            current_statement_begin__ = 32;
            check_greater_or_equal(function__, "q0", q0, 0);
            check_less_or_equal(function__, "q0", q0, 1);
            // write transformed parameters
            if (include_tparams__) {
                size_t mu_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t b1_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                    vars__.push_back(b1(j_1__));
                }
                size_t b2_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                    vars__.push_back(b2(j_1__));
                }
                size_t a1_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                    vars__.push_back(a1(j_1__));
                }
                size_t a2_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                    vars__.push_back(a2(j_1__));
                }
                size_t q0_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < q0_j_1_max__; ++j_1__) {
                    vars__.push_back(q0(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 88;
            validate_non_negative_index("log_lik", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 89;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 90;
                if (as_bool(logical_eq(get_base1(y, i, "y", 1), 0))) {
                    current_statement_begin__ = 91;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                stan::math::log(get_base1(q0, i, "q0", 1)), 
                                "assigning variable log_lik");
                } else {
                    current_statement_begin__ = 93;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (log1m(get_base1(q0, i, "q0", 1)) + log_mix(p, beta_log(get_base1(y, i, "y", 1), get_base1(a2, i, "a2", 1), get_base1(b2, i, "b2", 1)), beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1)))), 
                                "assigning variable log_lik");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 88;
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_VIB0";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t omega0_j_1_max__ = K0;
        for (size_t j_1__ = 0; j_1__ < omega0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t q0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < q0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "q0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t omega0_j_1_max__ = K0;
        for (size_t j_1__ = 0; j_1__ < omega0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t q0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < q0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "q0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_VIB0_namespace::model_VIB0 stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
