% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EW_liftoneDoptimal_MLM_func.R
\name{EW_liftoneDoptimal_MLM_func}
\alias{EW_liftoneDoptimal_MLM_func}
\title{function of EW liftone for multinomial logit model}
\usage{
EW_liftoneDoptimal_MLM_func(
  m,
  p,
  Xi,
  J,
  thetavec_matrix,
  link = "continuation",
  reltol = 1e-05,
  maxit = 500,
  p00 = NULL,
  random = FALSE,
  nram = 3
)
}
\arguments{
\item{m}{number of design points}

\item{p}{number of parameters in the multinomial logit model}

\item{Xi}{model matrix}

\item{J}{number of response levels in the multinomial logit model}

\item{thetavec_matrix}{the matrix of the sampled parameter values of beta}

\item{link}{multinomial logit model link function name "baseline", "cumulative", "adjacent", or"continuation", default to be "continuation"}

\item{reltol}{relative tolerance for convergence, default to 1e-5}

\item{maxit}{the number of maximum iteration, default to 500}

\item{p00}{specified initial approximate allocation, default to NULL, if NULL, will generate a random initial approximate allocation}

\item{random}{TRUE or FALSE, if TRUE then the function will run with additional "nram" number of initial allocation p00, default to be TRUE}

\item{nram}{when random == TRUE, the function will generate nram number of initial points, default is 3}
}
\value{
p              reported EW D-optimal approximate allocation

p0             the initial approximate allocation that derived the reported EW D-optimal design

Maximum        the maximum of the determinant of the expected Fisher information matrix

Convergence    TRUE or FALSE, whether the algorithm converges

itmax          maximum iterations
}
\description{
function of EW liftone for multinomial logit model
}
\examples{
m=7
p=5
J=3
link.temp = "continuation"
factor_x=c(80,100,120,140,160,180,200)
hfunc.temp = function(y){
matrix(data=c(1,y,y*y,0,0,0,0,0,1,y,0,0,0,0,0), nrow=3, ncol=5, byrow=TRUE)
}
Xi=rep(0,J*p*m); dim(Xi)=c(J,p,m)
for(i in 1:m) {
Xi[,,i]=hfunc.temp(factor_x[i])
}
bvec_bootstrap<-matrix(c(-0.2401, -1.9292, -2.7851, -1.614,-1.162,
                         -0.0535, -0.0274, -0.0096,-0.0291, -0.04,
                          0.0004,  0.0003,  0.0002,  0.0003,  0.1,
                         -9.2154, -9.7576, -9.6818, -8.5139, -8.56),nrow=4,byrow=TRUE)
EW_liftoneDoptimal_MLM_func(m=m, p=p, Xi=Xi, J=J, thetavec_matrix=bvec_bootstrap,
link = "continuation",reltol=1e-5, maxit=500, p00=rep(1/7,7), random=FALSE, nram=3)


}
