% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLM_Exact_Design.R
\name{GLM_Exact_Design}
\alias{GLM_Exact_Design}
\title{rounding algorithm for generalized linear models}
\usage{
GLM_Exact_Design(
  k.continuous,
  design_x,
  design_p,
  det.design,
  p,
  ForLion,
  bvec,
  Integral_based,
  b_matrix,
  joint_Func_b,
  Lowerbounds,
  Upperbounds,
  rel.diff,
  L,
  N,
  hfunc,
  link
)
}
\arguments{
\item{k.continuous}{number of continuous factors}

\item{design_x}{the matrix with rows indicating design point which we got from the approximate design}

\item{design_p}{the corresponding approximate allocation}

\item{det.design}{the determinant of the approximate design}

\item{p}{number of parameters}

\item{ForLion}{TRUE or FALSE, TRUE: this approximate design was generated by ForLion algorithm,
FALSE: this approximate was generated by EW ForLion algorithm}

\item{bvec}{If ForLion==TRUE assumed parameter values of model parameters beta, same length of h(y)}

\item{Integral_based}{TRUE or FALSE, if TRUE then we will find the integral-based EW D-optimality otherwise we will find the sample-based EW D-optimality}

\item{b_matrix}{The matrix of the sampled parameter values of beta}

\item{joint_Func_b}{The prior joint probability distribution of the parameters}

\item{Lowerbounds}{The lower limit of the prior distribution for each parameter}

\item{Upperbounds}{The upper limit of the prior distribution for each parameter}

\item{rel.diff}{points with distance less than that will be merged}

\item{L}{vector: rounding factors}

\item{N}{total number of observations}

\item{hfunc}{function for obtaining model matrix h(y) for given design point y, y has to follow the same order as n.factor}

\item{link}{link function, default "logit", other links: "probit", "cloglog", "loglog", "cauchit", "log", "identity"}
}
\value{
x.design            matrix with rows indicating design point

ni.design           exact allocation

rel.efficiency      relative efficiency of the Exact and Approximate Designs
}
\description{
rounding algorithm for generalized linear models
}
\examples{
k.continuous=1
design_x=matrix(c(25, -1, -1,-1, -1 ,
                 25, -1, -1, -1, 1,
                 25, -1, -1, 1, -1,
                 25, -1, -1, 1, 1,
                 25, -1, 1, -1, -1,
                 25, -1, 1, -1, 1,
                 25, -1, 1, 1, -1,
                 25, -1, 1, 1, 1,
                 25, 1, -1, 1, -1,
                 25, 1, 1, -1, -1,
                 25, 1, 1, -1, 1,
                 25, 1, 1, 1, -1,
                 25, 1, 1, 1, 1,
                 38.9479, -1, 1, 1, -1,
                 34.0229, -1, 1, -1, -1,
                 35.4049, -1, 1, -1, 1,
                 37.1960, -1, -1, 1, -1,
                 33.0884, -1, 1, 1, 1),nrow=18,ncol=5,byrow = TRUE)
hfunc.temp = function(y) {c(y,y[4]*y[5],1);};   # y -> h(y)=(y1,y2,y3,y4,y5,y4*y5,1)
link.temp="logit"
design_p=c(0.0848, 0.0875, 0.0410, 0.0856, 0.0690, 0.0515,
          0.0901, 0.0845, 0.0743, 0.0356, 0.0621, 0.0443,
          0.0090, 0.0794, 0.0157, 0.0380, 0.0455, 0.0022)
det.design=4.552715e-06
paras_lowerbound<-c(0.25,1,-0.3,-0.3,0.1,0.35,-8.0)
paras_upperbound<-c(0.45,2,-0.1,0.0,0.4,0.45,-7.0)
 gjoint_b<- function(x) {
 Func_b<-1/(prod(paras_upperbound-paras_lowerbound))
 ##the prior distributions are follow uniform distribution
return(Func_b)
}
 GLM_Exact_Design(k.continuous=k.continuous,design_x=design_x,
 design_p=design_p,det.design=det.design,p=7,ForLion=FALSE,Integral_based=TRUE,
 joint_Func_b=gjoint_b,Lowerbounds=paras_lowerbound, Upperbounds=paras_upperbound,
 rel.diff=0,L=1,N=100,hfunc=hfunc.temp,link=link.temp)
}
