% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FrechForest.R
\name{FrechForest}
\alias{FrechForest}
\title{Frechet Random Forest}
\usage{
FrechForest(Curve = NULL, Scalar = NULL, Factor = NULL,
  Shape = NULL, Image = NULL, Y, mtry = NULL, ntree = 100,
  ncores = NULL, ERT = FALSE, timeScale = 0.1, ntry = 3,
  imp = TRUE, ...)
}
\arguments{
\item{Curve}{[list]: A list that contains the different input curves. It must contain the following elements (no choice): \code{X} the matrix of the different curves, each column code for a different curve variable; \code{id} is the vector of the identifiers for the different trajectories contained in \code{X}; \code{time} is the vector of the measurement times associated with the trajectories contained in \code{X}.}

\item{Scalar}{[list]: A list that contains the different input scalars. It must contain the following elements (no choice):  \code{X} the matrix of the scalars, each column code for a different variable; \code{id} is the vector of the identifiers for each individual.}

\item{Factor}{[list]: A list that contains the different input factors. It must contain the following elements (no choice):  \code{X} the matrix of the factors, each column code for a different variable; \code{id} is the vector of the identifiers for each individual.}

\item{Shape}{[list]: A list that contains the different input shapes. It must contain the following elements (no choice):  \code{X} the array of the shapes of dimension \code{n}x2x\code{l}x\code{p} where \code{n} is the number of points for composing each shape, \code{l} is the number of shapes and \code{p} is the number of shapes variables, \code{id} is the vector of the identifiers for each individual.}

\item{Image}{[list]: A list that contains the different input images. It must contain the following elements (no choice):  \code{X} the array of the images of dimension \code{n}x\code{m}x\code{l}x\code{p} where \code{n}*\code{m} is the size of each image, \code{l} is the number of images and \code{p} is the number of shapes variables; \code{id} is the vector of the identifiers for each individual.}

\item{Y}{[list]: A list that contains the output, It must contain the following elements (no choice): \code{type} defines the nature of the output, can be "\code{curve}", "\code{sclalar}", "\code{factor}", "\code{shape}", "\code{image}"; \code{Y} is the output variable; \code{id} is the vector of the identifiers for each individuals, they should be the same as the identifiers of the inputs.}

\item{mtry}{[numeric]: Number of variables randomly sampled as candidates at each split. The default value \code{p/3}}

\item{ntree}{[numeric]: Number of trees to grow. This should not be set to too small a number, to ensure that every input row gets predicted at least a few times.}

\item{ncores}{[numeric]: Number of cores used to build Frechet randomized trees in parallel, defaulting to number of cores of the computer minus 1.}

\item{ERT}{[logical]: If \code{TRUE} uses Extremly Randomized Frechet Trees to build the Frechet forest.}

\item{timeScale}{[numeric]: Allow to modify the time scale, increasing or decreasing the cost of the horizontal shift. If timeScale is very big, then the Frechet mean tends to the Euclidean distance. If timeScale is very small, then it tends to the Dynamic Time Warping. Only used when there are trajectories either in input or output.}

\item{ntry}{[numeric]: Only with \code{ERT=TRUE}, allows to manage with randomness of the trees.}

\item{imp}{[logical]: TRUE to compute the variables importance FALSE otherwise (default \code{imp=}TRUE)}

\item{...}{: optional parameters to be passed to the low level function}
}
\value{
A Frechet random forest which is a list of the following elements: \itemize{
\item \code{rf:} a list of the \code{ntree} randomized Frechet trees that compose the forest.
\item \code{xerror :} a vector containing the OOB prediction error of each randomized Frechet tree composing the forest.
\item \code{OOB.err: } a vector containing the OOB prediction error of each individual in the learning sample.
\item \code{OOB.pred: } a list of the OOB prediction for each individual in the learning set.
\item \code{Importance: } A vector containing the variables importance.
\item \code{varex: } “pseudo R-squared”: Percentage of variance explained.
}
}
\description{
This function builds Frechet random Forest introduced by Capitaine et.al, this includes the OOB predictions, OOB errors and variable importance computations.
}
