% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_plot.R
\name{draw_plot}
\alias{draw_plot}
\title{Funnel Plots drawing function}
\usage{
draw_plot(mod_plot_agg, x_label, y_label, title, label_outliers,
  multiplier, Poisson_limits, OD_adjust, Tau2 = 0, method, yrange,
  xrange)
}
\arguments{
\item{mod_plot_agg}{data frame of containing numerator, denominator, ratio/proportion, SEs and limits}

\item{x_label}{Title for the funnel plot x-axis.  Usually expected deaths, readmissions, incidents etc.}

\item{y_label}{Title for the funnel plot y-axis.  Usually a standardised ratio.}

\item{title}{Plot title}

\item{label_outliers}{Add group labels to outliers on plot. Accepted values are\: 95 or 99 corresponding to 95\% or 99.8\% quantiles of the distribution. Default=99}

\item{multiplier}{Scale relative risk and funnel by this factor. Default to 1, but 100 is used for HSMR}

\item{Poisson_limits}{Draw exact limits based only on data points with no iterpolation. (default=FALSE)}

\item{OD_adjust}{Draw overdispersed limits using Spiegelhalter's (2012) Tau2 (default=TRUE)}

\item{Tau2}{The Tau2 value to use for plotting limits}

\item{method}{to pass to limit calculation (\"SHMI\" or \"CQC\")}

\item{yrange}{Specify the plot range. Default is "auto", else vector of length 2 e.g. c(0,200)}

\item{xrange}{Specify the plot range. Default is "auto", else vector of length 2 e.g. c(0,200)}
}
\value{
A list containing [1] the funnel plot as a ggplot2 object., [2]the limits table.
}
\description{
Internal function for drawing plot.  Do not use this directly, call `funnel_plot()` instead.
}
\keyword{internal}
