% Generated by roxygen2 (4.0.1): do not edit by hand
\name{FCLP.fixedBeta}
\alias{FCLP.fixedBeta}
\alias{FCLP.sampledBeta}
\title{Solves a Fuzzy Linear Programming problem with fuzzy constraints.}
\usage{
FCLP.fixedBeta(objective, A, dir, b, t, beta = 0.5, maximum = TRUE,
  verbose = TRUE)

FCLP.sampledBeta(objective, A, dir, b, t, min = 0, max = 1, step = 0.25,
  maximum = TRUE, verbose = TRUE)
}
\arguments{
\item{objective}{A vector \eqn{(c_1, c_2, \ldots, c_n)}{(c1, c2, \ldots, cn)} with the objective function coefficients \eqn{f(x)=c_1 x_1+\ldots+c_n x_n}{f(x)=c1*x1+\ldots+cn*xn}.}

\item{A}{Technological matrix of Real Numbers.}

\item{dir}{Vector of strings with the direction of the inequalities, of the same length as \code{b} and \code{t}. Each element
of the vector must be one of "=", ">=", "<=", "<" or ">".}

\item{b}{Vector with the right hand side of the constraints.}

\item{t}{Vector with the tolerance of each constraint.}

\item{beta}{The value of \eqn{\beta} to be used.}

\item{maximum}{\code{TRUE} to maximize the objective function, \code{FALSE} to minimize the objective function.}

\item{verbose}{\code{TRUE} to show aditional screen info, \code{FALSE} to hide aditional screen info.}

\item{min}{The lower bound of the interval to take the sample.}

\item{max}{The upper bound of the interval to take the sample.}

\item{step}{The sampling step.}
}
\value{
\code{FCLP.fixedBeta} returns the solution for the given beta if the solver has found it or NULL if not.

\code{FCLP.sampledBeta} returns the solutions for the sampled \eqn{\beta's} if the solver has found them.
If the solver hasn't found solutions for any of the \eqn{\beta's} sampled, return NULL.
}
\description{
The goal is to solve a linear programming problem having fuzzy constraints.
\deqn{Max\, f(x)\ or\ Min\ f(x)}{Max f(x) or Min f(x)}
\deqn{s.t.:\quad Ax<=b+(1-\beta)*t}{s.t.:  Ax<=b+(1-\beta)*t}
Where \eqn{t} means we allow not to satisfy the constraint, exceeding the bound \eqn{b} at most in \eqn{t}.

\code{FCLP.fixedBeta} uses the classic solver (simplex) to solve the problem with a fixed value of \eqn{\beta}.

\code{FCLP.sampledBeta} solves the problem in the same way than \code{\link{FCLP.fixedBeta}} but
using several \eqn{\beta's} taking values in a sample of the \eqn{[0,1]} inteval.
}
\examples{
## maximize:   3*x1 + x2
## s.t.:       1.875*x1   - 1.5*x2 <= 4 + (1-beta)*5
##              4.75*x1 + 2.125*x2 <= 14.5 + (1-beta)*6
##               x1, x2 are non-negative real numbers

obj <- c(3, 1)
A <- matrix(c(1.875, 4.75, -1.5, 2.125), nrow = 2)
dir <- c("<=", "<=")
b <- c(4, 14.5)
t <- c(5, 6)
valbeta <- 0.5
max <- TRUE

FCLP.fixedBeta(obj, A, dir, b, t, beta=valbeta, maximum = max, verbose = TRUE)
FCLP.sampledBeta(obj, A, dir, b, t, min=0, max=1, step=0.25, maximum = max, verbose = TRUE)
}
\references{
Verdegay, J.L. Fuzzy mathematical programming. In: Fuzzy Information and Decision Processes, pages 231-237, 1982. M.M. Gupta and E.Sanchez (eds).

Delgado, M. and Herrera, F. and Verdegay, J.L. and Vila, M.A. Post-optimality analisys on the membership function of a fuzzy linear programming problem. Fuzzy Sets and Systems, 53:289-297, 1993.
}
\seealso{
\code{\link{FCLP.classicObjective}}, \code{\link{FCLP.fuzzyObjective}}

\code{\link{FCLP.fuzzyUndefinedObjective}}, \code{\link{FCLP.fuzzyUndefinedNormObjective}}
}

