% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrapezoidalFuzzyNumber.R
\name{TrapezoidalFuzzyNumber}
\alias{TrapezoidalFuzzyNumber}
\title{R6 Class representing a 'TrapezoidalFuzzyNumber'.}
\description{
A 'TrapezoidalFuzzyNumber' is characterized by their four values inf0, inf1,
sup1 and sup0. Depending on its' values the 'TrapezoidalFuzzyNumber' can be valid
or not.
}
\note{
In case you find (almost surely existing) bugs or have recommendations
for improving the method, comments are welcome to the above mentioned mail addresses.
}
\examples{

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumber$new`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumber$new(1,2,3,4)

# Example 2:
TrapezoidalFuzzyNumber$new(-8,-6,-4,-2)

# Example 3:
TrapezoidalFuzzyNumber$new(-1,-1,2,3)

# Example 4:
TrapezoidalFuzzyNumber$new(1,2,3,3)

# Example 5:
TrapezoidalFuzzyNumber$new(1,0,2,3)

# Example 6:
TrapezoidalFuzzyNumber$new(-1,0,-0.5,0)

# Example 7:
TrapezoidalFuzzyNumber$new(-2,-4,-6,-8)

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumber$getInf0`
## ------------------------------------------------

TrapezoidalFuzzyNumber$new(1,2,3,4)$getInf0()

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumber$getInf1`
## ------------------------------------------------

TrapezoidalFuzzyNumber$new(1,2,3,4)$getInf1()

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumber$getSup1`
## ------------------------------------------------

TrapezoidalFuzzyNumber$new(1,2,3,4)$getSup1()

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumber$getSup0`
## ------------------------------------------------

TrapezoidalFuzzyNumber$new(1,2,3,4)$getSup0()

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumber$is_valid`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumber$new(1,2,3,4)$is_valid()

# Example 2:
TrapezoidalFuzzyNumber$new(-8,-6,-4,-2)$is_valid()

# Example 3:
TrapezoidalFuzzyNumber$new(1,0,2,3)$is_valid()

# Example 4:
TrapezoidalFuzzyNumber$new(-1,0,-0.5,0)$is_valid()

## ------------------------------------------------
## Method `TrapezoidalFuzzyNumber$is_positive`
## ------------------------------------------------

# Example 1:
TrapezoidalFuzzyNumber$new(1,2,3,4)$is_positive()

# Example 2:
TrapezoidalFuzzyNumber$new(-8,-6,-4,-2)$is_positive()

# Example 5:
TrapezoidalFuzzyNumber$new(1,0,2,3)$is_positive()

# Example 6:
TrapezoidalFuzzyNumber$new(-1,0,-0.5,0)$is_positive()
}
\author{
Andrea Garcia Cernuda <uo270115@uniovi.es>
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TrapezoidalFuzzyNumber-new}{\code{TrapezoidalFuzzyNumber$new()}}
\item \href{#method-TrapezoidalFuzzyNumber-getInf0}{\code{TrapezoidalFuzzyNumber$getInf0()}}
\item \href{#method-TrapezoidalFuzzyNumber-getInf1}{\code{TrapezoidalFuzzyNumber$getInf1()}}
\item \href{#method-TrapezoidalFuzzyNumber-getSup1}{\code{TrapezoidalFuzzyNumber$getSup1()}}
\item \href{#method-TrapezoidalFuzzyNumber-getSup0}{\code{TrapezoidalFuzzyNumber$getSup0()}}
\item \href{#method-TrapezoidalFuzzyNumber-is_valid}{\code{TrapezoidalFuzzyNumber$is_valid()}}
\item \href{#method-TrapezoidalFuzzyNumber-is_positive}{\code{TrapezoidalFuzzyNumber$is_positive()}}
\item \href{#method-TrapezoidalFuzzyNumber-clone}{\code{TrapezoidalFuzzyNumber$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumber-new"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumber-new}{}}}
\subsection{Method \code{new()}}{
This method creates a 'TrapezoidalFuzzyNumber' object with all its attributes
set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumber$new(inf0 = NA, inf1 = NA, sup1 = NA, sup0 = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inf0}}{is a real number that corresponds to the infimum of support
of the trapezoidal fuzzy number.}

\item{\code{inf1}}{is a real number that corresponds to the infimum of core of
the trapezoidal fuzzy number}

\item{\code{sup1}}{is a real number that corresponds to the supremum of core
of the trapezoidal fuzzy numbers}

\item{\code{sup0}}{is a real number that corresponds to the supremum of support
of the trapezoidal fuzzy numbers}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
The TrapezoidalFuzzyNumber object created with all its attributes set.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumber$new(1,2,3,4)

# Example 2:
TrapezoidalFuzzyNumber$new(-8,-6,-4,-2)

# Example 3:
TrapezoidalFuzzyNumber$new(-1,-1,2,3)

# Example 4:
TrapezoidalFuzzyNumber$new(1,2,3,3)

# Example 5:
TrapezoidalFuzzyNumber$new(1,0,2,3)

# Example 6:
TrapezoidalFuzzyNumber$new(-1,0,-0.5,0)

# Example 7:
TrapezoidalFuzzyNumber$new(-2,-4,-6,-8)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumber-getInf0"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumber-getInf0}{}}}
\subsection{Method \code{getInf0()}}{
This method gives the inf0 attribute of the 'TrapezoidalFuzzyNumber'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumber$getInf0()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
The inf0 attribute of the TrapezoidalFuzzyNumber object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{TrapezoidalFuzzyNumber$new(1,2,3,4)$getInf0()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumber-getInf1"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumber-getInf1}{}}}
\subsection{Method \code{getInf1()}}{
This method gives the inf1 attribute of the 'TrapezoidalFuzzyNumber'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumber$getInf1()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
The inf1 attribute of the TrapezoidalFuzzyNumber object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{TrapezoidalFuzzyNumber$new(1,2,3,4)$getInf1()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumber-getSup1"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumber-getSup1}{}}}
\subsection{Method \code{getSup1()}}{
This method gives the sup1 attribute of the 'TrapezoidalFuzzyNumber'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumber$getSup1()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
The sup1 attribute of the TrapezoidalFuzzyNumber object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{TrapezoidalFuzzyNumber$new(1,2,3,4)$getSup1()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumber-getSup0"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumber-getSup0}{}}}
\subsection{Method \code{getSup0()}}{
This method gives the sup0 attribute of the 'TrapezoidalFuzzyNumber'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumber$getSup0()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
The sup0 attribute of the TrapezoidalFuzzyNumber object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{TrapezoidalFuzzyNumber$new(1,2,3,4)$getSup0()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumber-is_valid"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumber-is_valid}{}}}
\subsection{Method \code{is_valid()}}{
This method gives information whether the 'TrapezoidalFuzzyNumber' is valid
regarding its attributes and checking conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumber$is_valid()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
TRUE whether the TrapezoidalFuzzyNumber object has non-decreasing
attributes, otherwise FALSE.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumber$new(1,2,3,4)$is_valid()

# Example 2:
TrapezoidalFuzzyNumber$new(-8,-6,-4,-2)$is_valid()

# Example 3:
TrapezoidalFuzzyNumber$new(1,0,2,3)$is_valid()

# Example 4:
TrapezoidalFuzzyNumber$new(-1,0,-0.5,0)$is_valid()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumber-is_positive"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumber-is_positive}{}}}
\subsection{Method \code{is_positive()}}{
This method gives information whether the 'TrapezoidalFuzzyNumber' is positive
regarding its attributes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumber$is_positive()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
TRUE whether the TrapezoidalFuzzyNumber object has all its attributes
greater than -1, otherwise FALSE.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
TrapezoidalFuzzyNumber$new(1,2,3,4)$is_positive()

# Example 2:
TrapezoidalFuzzyNumber$new(-8,-6,-4,-2)$is_positive()

# Example 5:
TrapezoidalFuzzyNumber$new(1,0,2,3)$is_positive()

# Example 6:
TrapezoidalFuzzyNumber$new(-1,0,-0.5,0)$is_positive()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrapezoidalFuzzyNumber-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TrapezoidalFuzzyNumber-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrapezoidalFuzzyNumber$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
