% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyNumber.R
\name{FuzzyNumber}
\alias{FuzzyNumber}
\title{R6 Class representing a 'FuzzyNumber'.}
\description{
A 'FuzzyNumber' is an array of dimension nl x 3 x 1. It must be valid.
}
\note{
In case you find (almost surely existing) bugs or have recommendations
for improving the method, comments are welcome to the above mentioned mail addresses.
}
\examples{

## ------------------------------------------------
## Method `FuzzyNumber$new`
## ------------------------------------------------

# Example 1:
FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3)))

# Example 2:
FuzzyNumber$new(array(c(0.0,1.0,1,2,4,3),dim=c(2,3)))

## ------------------------------------------------
## Method `FuzzyNumber$getAlphaLevels`
## ------------------------------------------------

FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$getAlphaLevels()

## ------------------------------------------------
## Method `FuzzyNumber$getInfimums`
## ------------------------------------------------

FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$getInfimums()

## ------------------------------------------------
## Method `FuzzyNumber$getSupremums`
## ------------------------------------------------

FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$getSupremums()

## ------------------------------------------------
## Method `FuzzyNumber$plot`
## ------------------------------------------------

# Example 1:
FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$plot()

# Example 2:
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 2, 1.7),dim=c(2,3))
)$plot("blue")

# Example 3:
Simulation$new()$simulCase1(1L)$transfTra()$getDimension(1L)$plot(palette())

# Example 4:
Simulation$new()$simulCase1(1L)$transfTra()$getDimension(1L)$plot(palette()[7])
}
\author{
Andrea Garcia Cernuda <uo270115@uniovi.es>
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FuzzyNumber-new}{\code{FuzzyNumber$new()}}
\item \href{#method-FuzzyNumber-getAlphaLevels}{\code{FuzzyNumber$getAlphaLevels()}}
\item \href{#method-FuzzyNumber-getInfimums}{\code{FuzzyNumber$getInfimums()}}
\item \href{#method-FuzzyNumber-getSupremums}{\code{FuzzyNumber$getSupremums()}}
\item \href{#method-FuzzyNumber-plot}{\code{FuzzyNumber$plot()}}
\item \href{#method-FuzzyNumber-clone}{\code{FuzzyNumber$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-new"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-new}{}}}
\subsection{Method \code{new()}}{
This method creates a valid 'FuzzyNumber' object with all its attributes set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$new(fnLevels = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fnLevels}}{is an array of dimension nl x 3 x 1 (general fuzzy number).
nl is the number of considered \eqn{\alpha}-levels and 3 is the number of
columns of the array. The first column represents the number of considered
\eqn{\alpha}-levels, the second one represents their infimum values and the
third and last column represents their supremum values.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
The FuzzyNumber object created with all its attributes set if it is
valid.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3)))

# Example 2:
FuzzyNumber$new(array(c(0.0,1.0,1,2,4,3),dim=c(2,3)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-getAlphaLevels"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-getAlphaLevels}{}}}
\subsection{Method \code{getAlphaLevels()}}{
This method gives the 'alphaLevels' array of the 'FuzzyNumber'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$getAlphaLevels()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
The array alphaLevels of the FuzzyNumber object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$getAlphaLevels()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-getInfimums"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-getInfimums}{}}}
\subsection{Method \code{getInfimums()}}{
This method gives the 'imfimums' array of the 'FuzzyNumber'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$getInfimums()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
The array imfimums of the FuzzyNumber object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$getInfimums()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-getSupremums"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-getSupremums}{}}}
\subsection{Method \code{getSupremums()}}{
This method gives the 'supremums' array of the 'FuzzyNumber'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$getSupremums()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
The array supremums of the FuzzyNumber object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$getSupremums()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-plot"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-plot}{}}}
\subsection{Method \code{plot()}}{
This method shows in a graph the values of the alphaLevels, infimums and
supremums attributes of the corresponding 'FuzzyNumber'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$plot(color = "grey")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color}}{is the color of the lines representing the number to be shown
in the graph. The default value is grey, other colors can be specified, the
option palette() too.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
a graph with the values of the alphaLevels, infimums and supremums
attributes of the corresponding 'FuzzyNumber'.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$plot()

# Example 2:
FuzzyNumber$new(array(c(0.0, 1.0, 1, 1.5, 2, 1.7),dim=c(2,3))
)$plot("blue")

# Example 3:
Simulation$new()$simulCase1(1L)$transfTra()$getDimension(1L)$plot(palette())

# Example 4:
Simulation$new()$simulCase1(1L)$transfTra()$getDimension(1L)$plot(palette()[7])
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
