% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rcpp_lm_gaga}
\alias{rcpp_lm_gaga}
\title{Fit a linear model via the GAGA algorithm using cpp.}
\usage{
rcpp_lm_gaga(
  X,
  y,
  s_alpha,
  s_itrNum,
  s_thresh,
  s_QR_flag,
  s_flag,
  s_lamda_0,
  s_fix_sigma,
  s_sigm2_0,
  s_fdiag,
  s_frp
)
}
\arguments{
\item{X}{Input matrix, of dimension nobs*nvars; each row is an observation.
If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.}

\item{y}{Quantitative response N*1 matrix.}

\item{s_alpha}{Hyperparameter. The suggested value for alpha is 2 or 3.}

\item{s_itrNum}{The number of iteration steps. In general, 20 steps are enough.}

\item{s_thresh}{Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.}

\item{s_QR_flag}{It identifies whether to use QR decomposition to speed up the algorithm.}

\item{s_flag}{It identifies whether to make model selection. The default is \code{TRUE}.}

\item{s_lamda_0}{The initial value of the regularization parameter for ridge regression.}

\item{s_fix_sigma}{It identifies whether to update the variance estimate of the Gaussian noise or not.}

\item{s_sigm2_0}{The initial variance of the Gaussian noise.}

\item{s_fdiag}{It identifies whether to use diag Approximation to speed up the algorithm.}

\item{s_frp}{Pre-processing by OMP method to reduce the number of parameters}
}
\value{
Coefficient vector
}
\description{
Fit a linear model via the GAGA algorithm using cpp.
}
