% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.r
\name{frank.fglm}
\alias{frank.fglm}
\title{F rank functional GLM}
\usage{
frank.fglm(nsim, formula.full, formula.reduced, curve_sets,
  factors = NULL, ..., GET.args = NULL, mc.cores = 1,
  mc.args = NULL)
}
\arguments{
\item{nsim}{The number of random permutations.}

\item{formula.full}{The formula specifying the general linear model,
see \code{formula} in \code{\link[stats]{lm}}.}

\item{formula.reduced}{The formula of the reduced model with nuisance factors only.}

\item{curve_sets}{A named list of sets of curves giving the dependent variable (Y), and
possibly additionally all the factors. The dimensions of the elements should
match with each other, i.e. the factor values should be given for each argument value
and each function. If factors are given in the argument \code{factors}, then can also be just
the curve set representing Y. Also \code{\link[fda.usc]{fdata}} objects allowed.}

\item{factors}{A data frame of factors. An alternative way to specify factors when they
are constant for all argument values. The number of rows of the data frame should be equal
to the number of curves. Each column should specify the values of a factor.}

\item{...}{Additional arguments to be passed to \code{\link[stats]{lm}}.}

\item{GET.args}{A named list of additional arguments to be passed to \code{\link{global_envelope_test}}.}

\item{mc.cores}{The number of cores to use, i.e. at most how many child processes will be run simultaneously.
Must be at least one, and parallelization requires at least two cores. On a Windows computer mc.cores must be 1
(no parallelization). For details, see \code{\link{mclapply}}, for which the argument is passed.
Parallelization can be used in generating simulations and in calculating the second stage tests.}

\item{mc.args}{A named list of additional arguments to be passed to \code{\link{mclapply}}.
Only relevant if \code{mc.cores} is more than 1.}
}
\value{
A \code{global_envelope} object, which can be printed and plotted directly.
}
\description{
Multiple testing in permutation inference for the general linear model (GLM)
}
\details{
The function \code{frank.fglm} performs
a nonparametric test of significance of a covariate in the functional GLM.
Similarly as in the graphical functional GLM (\code{\link{graph.fglm}}),
the Freedman-Lane algorithm (Freedman and Lane, 1983) is applied to permute the functions
(to obtain the simulations under the null hypothesis of "no effects");
consequently, the test approximately achieves the desired significance level.
In contrast to the graphical functional GLM, the F rank functional GLM is based on the F-statistics,
that are calculated at each argument value of the functions.
The global envelope test is applied to the observed and simulated F-statistics.
The test is able to find if the factor of interest is significant and also which
argument values of the functional domain are responsible for the potential rejection.
}
\examples{
data(GDPtax)
factors.df <- data.frame(Group = GDPtax$Group, Tax = GDPtax$Profittax)
\donttest{
res.tax_within_group <- frank.fglm(nsim = 999,
                                   formula.full = Y~Group+Tax+Group:Tax,
                                   formula.reduced = Y~Group+Tax,
                                   curve_sets = list(Y=GDPtax$GDP),
                                   factors = factors.df)
}
\dontshow{
res.tax_within_group <- frank.fglm(nsim = 4,
                                   formula.full = Y~Group+Tax+Group:Tax,
                                   formula.reduced = Y~Group+Tax,
                                   curve_sets = list(Y=GDPtax$GDP),
                                   factors = factors.df,
                                   GET.args = list(alpha=0.20))
}
plot(res.tax_within_group)
}
\references{
Mrkvička, T., Myllymäki, M. and Narisetty, N. N. (2019) New methods for multiple testing in permutation inference for the general linear model. arXiv:1906.09004 [stat.ME]

Freedman, D., & Lane, D. (1983) A nonstochastic interpretation of reported significance levels. Journal of Business & Economic Statistics, 1(4), 292-298. doi:10.2307/1391660
}
