% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes2d.r
\name{plot.combined_global_envelope2d}
\alias{plot.combined_global_envelope2d}
\title{Plot method for the class 'combined_global_envelope2d'}
\usage{
\method{plot}{combined_global_envelope2d}(x, plot_style = c("ggplot2",
  "basic"), fixedscales = 2, sign.col = "red", transparency = 85/255,
  contours = FALSE, main = NULL, digits = 3, ...)
}
\arguments{
\item{x}{an 'combined_global_envelope2d' object}

\item{plot_style}{Either "ggplot2" or "basic". (Similar to the argument in \code{\link{plot.global_envelope}}.)}

\item{fixedscales}{0, 1 or 2. See details.}

\item{sign.col}{The color for the significant regions. Default to "red".}

\item{transparency}{A number between 0 and 1 (default 85/255, 33% transparency).
Similar to alpha of \code{\link[grDevices]{rgb}}. Used in plotting the significant regions.}

\item{contours}{Logical. Whether to draw contour lines to the observed function and the lower and upper envelope.}

\item{main}{The overall main. Default exists.}

\item{digits}{The number of digits used for printing the p-value or p-interval in the main,
if using the default main.}

\item{...}{Additional parameters to be passed to \code{\link[spatstat]{plot.im}}.}
}
\description{
Plot method for the class 'combined_global_envelope2d'
}
\details{
Additional parameter \code{col} can be passed in \code{...} to \code{\link[spatstat]{plot.im}}.
If \code{col} not given, a \code{\link[spatstat]{colourmap}} of 255 grey values between the
minimum and maximum of the function values is used for each image separately.
If \code{col} is provided, the same specification will be used for each produced plot,
which may make it easier to compare the figures with each other.

If fixedscales is FALSE (or 0) all images will have separate scale.
If fixedscales is TRUE (or 1) each x[[i]] will have a common scale.
If fixedscales is 2 all images will have common scale.
}
