% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informativeNoisePrior.R
\name{informativeNoisePrior}
\alias{informativeNoisePrior}
\title{Informative noise residual prior}
\usage{
informativeNoisePrior(Y, opts, noiseProportion = 0.5, conf = 1)
}
\arguments{
\item{Y}{The data. For details, see function \code{\link{gfa}}.}

\item{opts}{Model options. See function \code{\link{getDefaultOpts}} for
details. If option tauGrouped is TRUE (default), each data source is given
equal importance (feature importance may vary within each
source). If it is FALSE, each feature is given equal importance.}

\item{noiseProportion}{proportion of total variance to be
explained by noise. Suggested to lie between 0.01 and 0.99.}

\item{conf}{Confidence in the prior, relative to confidence in the data.
Suggested to lie between 0.01 and 100.}
}
\value{
The input model options (opts) with an updated residual
  noise prior, corresponding to the elements prior.alpha_0t and
  prior.beta_0t.
}
\description{
\code{informativeNoisePrior} returns an informative noise prior for GFA, for
a given data collection. The function sets the noise residual parameters
such that the expected proportion of
variance explained is for all variables and groups (in contrast to being
proportional to their original scale). Recommended e.g. when the data is
'small n, large p', and the standard prior from \code{\link{getDefaultOpts}}
seems to overfit the model by not shutting off any component with high
initial K.
}
\examples{
#Given data collection Y
opts <- getDefaultOpts()
\dontrun{opts <- informativeNoisePrior(Y,opts,0.2,1)}
\dontrun{res <- gfa(Y,opts=opts)}
}
