% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eip.R
\name{eip}
\alias{eip}
\title{Edge Inclusion "Probability"}
\usage{
eip(Y, method = "pearson", B = 1000, progress = TRUE)
}
\arguments{
\item{Y}{The data matrix of dimensions \emph{n} (observations) by \emph{p} (nodes).}

\item{method}{Character string. Which type of correlation coefficients
to be computed. Options include \code{"pearson"} (default),
\code{"kendall"}, \code{"spearman"}, and \code{"polychoric"}.}

\item{B}{Integer. Number of bootstrap replicates (defaults to \code{1000}).}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE})?}
}
\value{
An object of class \code{eip}, including a matrix of edge inclusions.
}
\description{
Compute the proportion of bootstrap samples that each relation was selected.
}
\details{
The order is the upper-triangular.
}
\examples{
\donttest{
# data
Y <- ptsd

# eip
fit_eip <- eip(Y, method = "spearman")

# print
fit_eip
}
}
