% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ss.ng.ssize.oc.df.r
\name{get.ss.ng.ssize.oc.df}
\alias{get.ss.ng.ssize.oc.df}
\title{Get single sample normal-gamma sample size Oc curve data.frame}
\usage{
get.ss.ng.ssize.oc.df(
  mu.0.t = 3,
  n.0.t = 10,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  s.t = 5,
  n.t = 50,
  SS.OC.N.LB = floor(50 * 0.75),
  SS.OC.N.UB = floor(50 * 2),
  npoints = 15,
  Delta.lrv = 2.5,
  Delta.tv = 4,
  Delta.user = 3,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65
)
}
\arguments{
\item{mu.0.t}{prior mean for treatment group}

\item{n.0.t}{prior effective sample size for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{s.t}{sample sd for treatment group}

\item{n.t}{sample size for treatment group}

\item{SS.OC.N.LB}{lower bound for OC curve}

\item{SS.OC.N.UB}{upper bound for OC curve}

\item{npoints}{number of points}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{Delta.user}{User's value for underlying treatment response}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}
}
\value{
A data.frame is returned
}
\description{
Get single sample normal-gamma sample size Oc curve data.frame
}
\examples{
\donttest{
my.ss.ng.ssize.oc.df <- get.ss.ng.ssize.oc.df()
head(my.ss.ng.ssize.oc.df)
}
}
