% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.ss.bin.ria.r
\name{make.ss.bin.ria}
\alias{make.ss.bin.ria}
\title{Make single sample binary rule in action plot}
\usage{
make.ss.bin.ria(
  a.trt = 1,
  b.trt = 1,
  n.trt = 40,
  x.trt = 9,
  Delta.lrv = 0.2,
  Delta.tv = 0.35,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  seed = 1234,
  nlines = 25,
  tsize = 4,
  nlines.ria = 20,
  add.table = TRUE
)
}
\arguments{
\item{a.trt}{prior alpha parameter}

\item{b.trt}{prior beta parameter}

\item{n.trt}{observed sample size}

\item{x.trt}{observed number of responders}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{seed}{random seed}

\item{nlines}{Control for text spacing}

\item{tsize}{Control for text size}

\item{nlines.ria}{number of lines}

\item{add.table}{provides extended output summaries}
}
\value{
A ggplot object is returned
}
\description{
Make single sample binary rule in action plot
}
\examples{
my.ss.bin.ria <- make.ss.bin.ria(x.trt=10, add.table=TRUE)
plot(my.ss.bin.ria[[1]])
my.ss.bin.ria[[2]]
my.ss.bin.ria[[3]]
my.ss.bin.ria[[4]]
}
