% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnorgam.r
\name{normal.gamma}
\alias{normal.gamma}
\alias{dnorgam}
\alias{rnormgam}
\title{Density function for the Normal-Gamma distribution}
\usage{
dnorgam(mu, tau, mu0, n0, a0, b0)

rnormgam(n = 1e+05, mu.0 = 0, n.0 = 1, alpha.0 = 0.01, beta.0 = 0.01)
}
\arguments{
\item{mu}{likelihood evaluated when mean takes on value mu}

\item{tau}{likelihood evaluated when precision takes on value tau}

\item{mu0}{hyperparameter describing mu}

\item{n0}{hyperparameter describing effective sample size associated with mu0}

\item{a0}{hyperparameter describing shape parameter of precision parameter}

\item{b0}{hyperparameter describing rate parameter of precision parameter}

\item{n}{number of observations}

\item{mu.0}{hyperparameter describing mu}

\item{n.0}{hyperparameter describing effective sample size associated with mu0}

\item{alpha.0}{hyperparameter describing shape parameter of precision parameter}

\item{beta.0}{hyperparameter describing rate parameter of precision parameter}
}
\value{
Returns the value of the Normal-gamma density function at the point passed.
}
\description{
Density function for the Normal-Gamma distribution
}
\examples{
dnorgam(100, .25, 0, 10, 0, .25)
rnormgam()
}
