% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreeDistCC.R
\name{Level2NoLeafNodeCC}
\alias{Level2NoLeafNodeCC}
\title{Non-leaf GO-terms on a GO CC level}
\usage{
Level2NoLeafNodeCC(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO level}

\item{organism}{The organism of interest from the list of supported organism. If NULL the results are from the general GO-DAG (default)}
}
\value{
A set of non-leaf GO terms
}
\description{
This function returned all the non-leaf GO terms on a particular GO CC level. The supported
             organism are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast", "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli"
}
\examples{
# Non-leaf nodes from level 16 for Yeast CC GO-DAG
Level2NoLeafNodeCC(level = 16, "Yeast")

# Non-leaf nodes from level 10 for Mouse CC GO-DAG
Level2NoLeafNodeCC( 10, "Mus musculus")

}
