% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPSeq_clus.R
\name{GPSeq_clus}
\alias{GPSeq_clus}
\title{Sequential cluster algorithm of location data}
\usage{
GPSeq_clus(
  dat,
  search_radius_m,
  window_days,
  clus_min_locs = 2,
  centroid_calc = "mean",
  show_plots = c(TRUE, "mean"),
  season_breaks_jul = NA,
  daylight_hrs = NA
)
}
\arguments{
\item{dat}{Any dataframe including single or multiple animal location datasets that includes:
\describe{
  \item{$AID}{Animal identification for each location}
  \item{$TelemDate}{Location timestamps as POSIXct format "YYYY-MM-DD HH:MM:SS" with single "tzone" attribute}
  \item{$Long}{Longitude values as decimal degrees (-180 to +180) including NAs for failed fixes}
  \item{$Lat}{Latitude values as decimal degrees (-90 to +90) including NAs for failed fixes}
}}

\item{search_radius_m}{Search radius (meters) from cluster centroid when building clusters.}

\item{window_days}{Temporal window (days) to search for new locations from the most recent location in a cluster}

\item{clus_min_locs}{Minimum number of locations required to form a cluster. Default is 2.}

\item{centroid_calc}{Method for recalculating centroids when actively building clusters - e.g., "median" or "mean" (default). Not to be confused with
plotting the "mean" or "median" centroid once a cluster has been built.}

\item{show_plots}{Vector of TRUE/FALSE for plotting followed by plotting argument for the "median" or "mean" centroid - e.g., c(TRUE, "mean") (default)}

\item{season_breaks_jul}{Ascending numeric vector of julian days (0-365) used to classify by season/parturition/hunting seasons etc.
e.g., c(121, 274, 305) result may be: 1 Nov - 30 Apr (winter = 0), 1 May - 31 Aug (summer = 1), 1 Oct - 31 Oct (hunting season = 2)}

\item{daylight_hrs}{Manually set start and stop hours (0-24) to classify day and night locations. - e.g. c(6,18) would classify 6AM - 6PM as daylight hrs.
NA (default) uses 'suncalc' package to convert cluster location and time to be classified based on specific specific sunrise and sunset times.}
}
\value{
Returns "dat" dataframe, original location dataframe with "clus_ID" column assigning each row a cluster ID if applicable. Returns "clus_summary"
        dataframe with sequential clusters for all animals and common attributes (descriptions below) of clusters as covariates for subsequent modeling. If show_plots is active, returns
        interactive map of locations and clusters by animal.

\describe{
  \item{AID}{Animal identification}
  \item{clus_ID}{Sequential cluster ID number}
  \item{clus_start}{Timestamp of first location in cluster}
  \item{clus_end}{Timestamp of last location in cluster}
  \item{clus_status}{"Closed" if the time window (window_days) has expired for the cluster according to users Sys.time() output.
                     These clusters are therefore solidified and should not change if appending new location data.
                     "Open" if the time window remains open at the time the function was run. "Open" clusters have the ability
                     to shift sequence, combine with other clusters, emerge as a new cluster, etc. This attribute becomes
                     relevent when appending new satellite data to the location dataframe, and may serve as an index of whether
                     an animal continues to actively visit the cluster site within the time window.}
  \item{g_c_Long}{Geometic centroid longitude value calculated using the mean}
  \item{g_c_Lat}{Geometic centroid latitude value calculated using the mean}
  \item{g_med_Long}{Geometic centroid longitude value calculated using the median}
  \item{g_med_Lat}{Geometic centroid latitude value calculated using the median}
  \item{clus_dur_hr}{Hours from the first to last locations of the cluster}
  \item{n_clus_locs}{Number of locations within the cluster}
  \item{visits}{Number of visits/revists to the cluster based on the number of times locations fall outside the search radius and return
                to add locations to the cluster}
  \item{fix_succ_clus_dur}{Fix rate success during the duration of the cluster}
  \item{adj_clus_locs}{Adjusted number of cluster locations accounting for missed fixes (number cluster locations / fix success of cluster duration)}
  \item{fid}{Fidelity to the cluster during cluster duration (number locations on cluster - number locations off cluster)}
  \item{max_foray}{Maximum location distance (meters) from centroid during cluster duration for all locations}
  \item{clus_radius}{Maximum location distance (meters) from centroid during cluster duration for cluster-attributed locations}
  \item{avg_clus_dist}{Mean distance from all cluster locations to centroid}
  \item{n_24_per}{Number of unique 24 hr periods during the cluster duration that hold at least one cluster location}
  \item{bin_24hr}{Binary output for cluster duration (0 == less or equal to 24hr, 1 == greater than 24hr)}
  \item{season}{Nominal attribute for user defined seasons based on 'season_breaks_jul' argument}
  \item{night_pts}{Number of night cluster locations based on 'daylight_hrs' argument}
  \item{night_prop}{Proportion of night cluster locations}
}
}
\description{
Applies sequential clustering algorithm to location data based on user-defined parameters
and appends results to the dataframe. Provides a summary dataframe with attributes for each cluster
commonly used as covariates in subsequent modeling efforts. Plots interactive cluster maps.
}
\examples{
GPSeq_clus(dat = ML_ex_dat[1:50,], search_radius_m = 200, window_days = 6,
           clus_min_locs = 3, show_plots = c(FALSE, "mean"))

\donttest{
GPSeq_clus(dat = ML_ex_dat, search_radius_m = 50, window_days = 2.5, clus_min_locs = 12,
                 centroid_calc = "median", show_plots = c(TRUE, "median"),
                 season_breaks_jul = c(120, 240, 300), daylight_hrs = c(8, 16))
}

}
