% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WrappedGP.R
\name{WrappedGP}
\alias{WrappedGP}
\title{R6 class WrappedGP}
\description{
Contains the GP created by a user-defined GP package
}
\details{
This is effectively a dummy wrapper based on the wrapper for the mlegp package (see \link{WrappedmlegpGP}). It contains a basic implementation of the wrapper. The vignette offers a tutorial on how to change this wrapper for the new GP package.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{gp}}{The mlegp GP object (\link[mlegp:mlegp]{mlegp::mlegp} in the \code{mlegp} manual)}

\item{\code{X_buffer}}{Buffer matrix to collect x points until first GP can be trained}

\item{\code{y_buffer}}{Buffer vector to collect y points until first GP can be trained}

\item{\code{y_var_buffer}}{Buffer vector to collect variance of y points until first GP can be trained}

\item{\code{add_y_var}}{Small additional variance used to keep the covariance matrix condition number under control}

\item{\code{n_points_train_limit}}{Number of points needed before we can create the GP}

\item{\code{n_points}}{The number of collected points belonging to this GP}

\item{\code{x_dim}}{Dimensionality of input points}

\item{\code{gp_control}}{A list of GP implementation-specific options, passed directly to the wrapped GP implementation}

\item{\code{init_covpars}}{The initial covariance parameters when training the mlegp GP object in self@gp}

\item{\code{estimate_covpars}}{If TRUE, the parameters are estimated by the package. Otherwise, the parameters from init_covpars are taken}

\item{\code{retrain_buffer_length}}{Only retrain after this many new points have been added to the buffer}

\item{\code{retrain_buffer_counter}}{Counter for the number of new points added since last retraining}

\item{\code{add_buffer_in_prediction}}{If TRUE, points in the data buffers are added to the GP before prediction. They are added into a temporarily created GP which contains the not yet included points. The GP in the node is not yet updated.}

\item{\code{X_shared}}{Matrix with x points that this GP shares with the GP in the sibling node}

\item{\code{y_shared}}{Vector of y points that this GP shares with the GP in the sibling node}

\item{\code{y_var_shared}}{Vector of y_var points that this GP shares with the GP in the sibling node}

\item{\code{n_shared_points}}{The number of own points shared with the GP in the sibling node}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WrappedGP-new}{\code{WrappedGP$new()}}
\item \href{#method-WrappedGP-update_init_covpars}{\code{WrappedGP$update_init_covpars()}}
\item \href{#method-WrappedGP-get_lengthscales}{\code{WrappedGP$get_lengthscales()}}
\item \href{#method-WrappedGP-get_X_data}{\code{WrappedGP$get_X_data()}}
\item \href{#method-WrappedGP-get_y_data}{\code{WrappedGP$get_y_data()}}
\item \href{#method-WrappedGP-get_y_var_data}{\code{WrappedGP$get_y_var_data()}}
\item \href{#method-WrappedGP-get_cov_mat}{\code{WrappedGP$get_cov_mat()}}
\item \href{#method-WrappedGP-update_add_y_var}{\code{WrappedGP$update_add_y_var()}}
\item \href{#method-WrappedGP-store_point}{\code{WrappedGP$store_point()}}
\item \href{#method-WrappedGP-delete_buffers}{\code{WrappedGP$delete_buffers()}}
\item \href{#method-WrappedGP-delete_gp}{\code{WrappedGP$delete_gp()}}
\item \href{#method-WrappedGP-call_create_gp}{\code{WrappedGP$call_create_gp()}}
\item \href{#method-WrappedGP-call_predict}{\code{WrappedGP$call_predict()}}
\item \href{#method-WrappedGP-train}{\code{WrappedGP$train()}}
\item \href{#method-WrappedGP-predict}{\code{WrappedGP$predict()}}
\item \href{#method-WrappedGP-clone}{\code{WrappedGP$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-new"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-new}{}}}
\subsection{Method \code{new()}}{
Create a new WrappedmlegpGP object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$new(
  X,
  y,
  y_var,
  gp_control,
  init_covpars,
  retrain_buffer_length,
  add_buffer_in_prediction,
  estimate_covpars = TRUE,
  X_shared = NULL,
  y_shared = NULL,
  y_var_shared = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Input data matrix with x_dim columns and at maximum Nbar rows. Is used to create the first iteration of the local GP.}

\item{\code{y}}{Value of target variable at input point x; has to be a one-dimensional matrix or a vector; any further columns will be ignored}

\item{\code{y_var}}{Variance of the target variable; has to be a one-dimensional matrix or vector}

\item{\code{gp_control}}{A list of GP implementation-specific options, passed directly to the wrapped GP implementation}

\item{\code{init_covpars}}{Initial covariance parameters of the local GP}

\item{\code{retrain_buffer_length}}{Only retrain when the number of buffer points or collected points exceeds this value}

\item{\code{add_buffer_in_prediction}}{If TRUE, points in the data buffers are added to the GP before prediction. They are added into a temporarily created GP which contains the not yet included points. The GP in the node is not yet updated.}

\item{\code{estimate_covpars}}{If TRUE, the parameters are estimated by the package. Otherwise, the parameters from init_covpars are taken}

\item{\code{X_shared}}{Matrix with x points that this GP shares with the GP in the sibling node}

\item{\code{y_shared}}{Vector of y points that this GP shares with the GP in the sibling node}

\item{\code{y_var_shared}}{Vector of y_var points that this GP shares with the GP in the sibling node}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new WrappedGP object. Besides the local GP, information on the shared points and those stored in the buffer are collected. For more information on the GP, consult the respective met in the GP package.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-update_init_covpars"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-update_init_covpars}{}}}
\subsection{Method \code{update_init_covpars()}}{
Stores the initial covariance parameters (length-scales, standard deviation and trend coefficients) of the GP in the field \code{init_covpars}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$update_init_covpars()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-get_lengthscales"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-get_lengthscales}{}}}
\subsection{Method \code{get_lengthscales()}}{
Retrieves the length-scales of the kernel of the local GP
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$get_lengthscales()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-get_X_data"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-get_X_data}{}}}
\subsection{Method \code{get_X_data()}}{
Retrieves the design matrix X
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$get_X_data(include_shared = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_shared}}{If TRUE, shared points between this GP and its sibling GP are included}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-get_y_data"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-get_y_data}{}}}
\subsection{Method \code{get_y_data()}}{
Retrieves the response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$get_y_data(include_shared = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_shared}}{If TRUE, shared points between this GP and its sibling GP are included}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-get_y_var_data"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-get_y_var_data}{}}}
\subsection{Method \code{get_y_var_data()}}{
Retrieves the individual variances from the response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$get_y_var_data(include_shared = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_shared}}{If TRUE, shared points between this GP and its sibling GP are included}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-get_cov_mat"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-get_cov_mat}{}}}
\subsection{Method \code{get_cov_mat()}}{
Retrieves the covariance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$get_cov_mat()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the covariance matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-update_add_y_var"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-update_add_y_var}{}}}
\subsection{Method \code{update_add_y_var()}}{
Method for updating add_y_var based on a bound for the covariance matrix condition number, based on \href{https://arxiv.org/abs/1602.00853}{this paper}, Section 5.4
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$update_add_y_var(max_cond_num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_cond_num}}{Max allowed condition number}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-store_point"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-store_point}{}}}
\subsection{Method \code{store_point()}}{
Stores a new point into the respective buffer method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$store_point(x, y, y_var, shared = FALSE, remove_shared = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Single input data point from the data stream; has to be a vector or row matrix with length equal to x_dim}

\item{\code{y}}{Value of target variable at input point x; has to be a one-dimensional matrix or a vector; any further columns will be ignored}

\item{\code{y_var}}{Variance of the target variable; has to be a one-dimensional matrix or vector}

\item{\code{shared}}{If TRUE, this point is shared between this GP and its sibling GP}

\item{\code{remove_shared}}{If TRUE, the last of the shared points is removed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-delete_buffers"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-delete_buffers}{}}}
\subsection{Method \code{delete_buffers()}}{
Method for clearing the buffers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$delete_buffers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-delete_gp"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-delete_gp}{}}}
\subsection{Method \code{delete_gp()}}{
Method to delete the GP object in self$gp
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$delete_gp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-call_create_gp"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-call_create_gp}{}}}
\subsection{Method \code{call_create_gp()}}{
Method for calling the 'mlegp' function in mlegp to create a GP object, stored in self$gp
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$call_create_gp(X, y, y_var)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Input data matrix with x_dim columns and at maximum Nbar rows for the local GP.}

\item{\code{y}}{Value of target variable at input point x; has to be a one-dimensional matrix or a vector; any further columns will be ignored}

\item{\code{y_var}}{Variance of the target variable; has to be a one-dimensional matrix or vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-call_predict"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-call_predict}{}}}
\subsection{Method \code{call_predict()}}{
Method for calling the 'predict' function in mlegp
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$call_predict(x, use_gp = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Single data point for which the predicted mean (and standard deviation) is computed; has to be a vector with length equal to x_dim}

\item{\code{use_gp}}{Optional user-defined GP which is evaluated instead of the local GP}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The predictions for x from the specified GP, by default the local GP. The output needs to be a list with fields mean and sd for the prediction and prediction error, respectively.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-train"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-train}{}}}
\subsection{Method \code{train()}}{
Method for (re)creating / (re)training the GP
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$train(do_buffer_check = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{do_buffer_check}}{If TRUE, only train the GP if the number of stored points is larger than retrain_buffer_length}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if training was performed, otherwise FALSE
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-predict"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-predict}{}}}
\subsection{Method \code{predict()}}{
Method for prediction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$predict(x, return_std = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Single data point for which the predicted mean (and standard deviation) is computed; has to be a vector or row matrix with length equal to x_dim}

\item{\code{return_std}}{If TRUE, the standard error is returned in addition to the prediction}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Prediction for input point x
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WrappedGP-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WrappedGP-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WrappedGP$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
